# Schema as of Fri Jun 29 21:58:21 EDT 2007 (schema version 45)
#
#  id                  :integer(11)   not null
#  parent_id           :integer(11)   
#  user_id             :integer(11)   
#  content_type        :string(255)   
#  filename            :string(255)   
#  thumbnail           :string(255)   
#  size                :integer(11)   
#  width               :integer(11)   
#  height              :integer(11)   
#

class Avatar < ActiveRecord::Base
  belongs_to :user
  
  after_create :destroy_unattached_records
  
  has_attachment :content_type => :image, 
                 :storage => :file_system, 
                 :max_size => 500.kilobytes,
                 :resize_to => '320x200>',
                 :thumbnails => { :thumb => '80x80>' }
  
  validates_as_attachment
  
  def destroy_unattached_records
    self.class.destroy_all('user_id IS NULL && parent_id IS NULL') # will cascade down to delete thumbnails
  end
end
