module UniformLinkHelper
  def cancel
    link_to "cancel", {:action => 'index'}, :class => 'cancel'
  end
  
  def add(options = {}, link_text = "add")
    link_to link_text, {:action => 'new'}.merge(options), :class => 'add'
  end
  
  def edit(record, html_options = {})
    link_to "edit", {:action => 'edit', :id => record}, {:class => 'edit'}.merge(html_options)
  end
  
  def remove(record)
    link_to "remove", { :action => 'remove', :id => record }, :confirm => 'Are you sure? This action cannot be undone.', :class => 'remove'
  end
  
  def create_or_save(object, label = nil)
    label ||= object.class.to_s.underscore.titleize # should this be a model method?
    submit_tag object.new_record? ? "Create this #{label}" : "Save this #{label}"
  end
  
  def hold(record)
    link_to "hold", {:action => 'hold', :id => record }, :class => 'hold', :title => 'toggle to hold'
  end
  
  def approve(record)
    link_to "approve", {:action => 'approve', :id => record }, :class => 'approve', :title => 'toggle to approve'
  end
  
end