module MetricsHelper
  
  # the second(common) half of the comment row
  def comment_row_common(comment, include_topic = true)
    s = String.new
    s << content_tag(:td, truncate(comment.topic.title)) if include_topic
    s << content_tag(:td, comment.user.name)
    s << content_tag(:td, link_to(truncate(comment.body), 
          {
              :controller => 'topics',
              :action => 'show',
              :id => comment.topic.id,
              :anchor => "comment_#{comment.id}" 
          }
        )
      )
  end
    
  def top5_row(record, include_topic = true)
    case params[:model]
      when 'comment': comment_row_common(record, include_topic)
      when 'user': user_row_common(record)
      when 'topic':   content_tag(:td, link_to(truncate(record.title), {
            :controller => 'topics',
            :action => 'show',
            :id => record.id } )
        )
      
      else raise ArgumentError
    end
  end
  
  def user_row_common(user)
    content_tag(:td, link_to(user.name, {
        :controller => 'users',
        :action => 'show',
        :id => user.id } )
    )
  end
  
  # returns the HTML code for a single row form the metrics grid
  def topic_attribute_row(metrics_grid, topic)
    [:comment_count, :comment_words, :rating_count, :rating_mean ].collect do |name|
      stats = metrics_grid.for_topic(topic) || {}
      value = stats[name]
      td_html_attributes = {:class => 'number'}
      td_html_attributes = {:class => 'number max'} if metrics_grid.is_best?(name, value)
      content_tag(:td, 
        topic_attribute(value),
        td_html_attributes)
    end.join("\n")
  end
  
  def topic_attribute(value)
    case value
    when NilClass:
      '-'
    when Float:
      number_with_precision(value, 1)
    else
      value
    end    
  end
  
  def sup_link(support_material)
    link_to(support_material.name, {:controller => 'viewer', :id => support_material.id}, :title => support_material.topic.title)
  end
  
  def link_table_rows(array_of_models, labels={})
    array_of_models.collect do |model|
        content_tag( :tr, 
          content_tag( :th, labels[model] || model.humanize) +
          content_tag( :td, @report.count[model], :class => 'number') +
          content_tag( :td, link_to('show',     {:action => 'export_html', :model => model, :id => params[:id]}, :class => 'show-table' ) ) +
          content_tag( :td, link_to('download', {:action => 'export_csv',  :model => model, :id => params[:id]}, :class => 'export') )
        ) 
    end    
  end
  
  def link_table_rows_with_means(array_of_models)
    array_of_models.collect do |model|
        content_tag( :tr, 
          content_tag( :th, model.humanize) +
          content_tag( :td, @report.count[model], :class => 'number') +
          content_tag( :td, number_with_precision(@report.mean_rating[model], 1), :class => 'number') +
          content_tag( :td, link_to('show',     {:action => 'export_html', :model => model, :id => params[:id]}, :class => 'show-table' ) ) +
          content_tag( :td, link_to('download', {:action => 'export_csv',  :model => model, :id => params[:id]}, :class => 'export') )
        ) 
    end    
  end
  
  def top5_link(text, url_options)
    target = "#{url_options[:model]}-top-5-target"
    link_to_remote text, 
      :update => target, 
      :url => {:action => 'top5', :time_scope => params[:time_scope], :id => params[:id]}.merge(url_options),
      :loading =>  update_element_function(target, :content => "Loading..."),
      :complete => visual_effect(:highlight, target, :duration => 0.5)
  end
  
  def top5_table_header
    case params[:model]
    when 'comment':
      topic_col =  params[:id] ? "" : "<th>Topic</th>"
      "<tr>
          <th>#{params[:what].humanize}</th>
          #{topic_col}
          <th>User</th>
          <th>Comment</th>
      </tr>"
    when "user":
      "<tr>
          <th>#{params[:what].humanize}</th>
          <th>User</th>
      </tr>"
    when 'topic':
      "<tr>
          <th>#{params[:what].humanize}</th>
          <th>Topic</th>
      </tr>"
    else
      raise ArgumentError
    end
  end
  
  def nice_number(value)
    value.is_a?(Float) ?  number_with_precision(value, 1) : value
  end
end
