# Methods added to this helper will be available to all templates in the application.
module ApplicationHelper

  def current_user
    @current_user
  end
  
  def guest?
    current_user.instance_of? Guest
  end
  
  def consultation_title
    Settings.consultation_name
  end
  
  def topic_box(topics) # TODO this should be a partial, since it involves routing(?)
    content_tag(:div,
      '<h2>Last 5 Topics</h2>' +
      content_tag(:ol, 
        topics.collect do |topic|
          content_tag(:li, 
          content_tag(:span,
            link_to_unless_current( topic.title, :controller => 'topics', :action => 'show', :id => topic.id ) +
            (topic.for_future? ? "(not yet available)" : '')
            )
          )
        end.join("\n") +
        (current_user.has_permission_to?(:topics_new) ? "<p>#{add({}, 'add topic')}</p>" : '') 
      ),
    :class => 'box')
  end
  
  def snippet(snippet)
    content_tag(:div, 
      snippet.body.blank? ? "*#{snippet.name} is not yet set*" : smarty_markdown(snippet.body), 
      {:id => snippet.name} 
    ) + 
    (edit_snippet_link(snippet) || '' )
  end
  
  def edit_snippet_link(snippet)
    link_to "Edit this snippet", {:controller => 'snippets', :action => "edit", :id => snippet.id} if current_user && current_user.role == :admin
  end
    
  def navbar
    item = []
    item << (link_to "Home", '/')
    if logged_in? || ApplicationPolicy::guests_allowed?
      item << (link_to "All Topics", {:controller => 'topics', :action => 'archives'}, :class=>"archives" )
      item << subscribe_to_rss_link
      # item << (link_to "Library", {:controller => 'library'}, :class=>"library" ) if ApplicationPolicy::show_support_material?
      if current_user && current_user.role == :admin  
        item << (link_to "Administrative Control Panel", { :controller => 'system'}, :class=>"system")
      end 
      item <<  (link_to "About Us", {:controller => 'snippets', :action => 'show_by_name', :name => 'about'}, :class => 'about' )
    end
    item.join(' | ') 
  end

  def admin_nav
    item = []
    item << (link_to "Home", '/')
    if logged_in? || ApplicationPolicy::guests_allowed?
      item << (link_to "Topics", {:controller => 'topics', :action => 'list', :topic_id => nil}, :class=>"list" )
      if current_user && current_user.role == :admin  
        item << (link_to "Library", {:controller => 'library', :action => 'list', :topic_id => nil}, :class=>"library" )
        item << (link_to "Metrics", { :controller => 'metrics', :topic_id => nil})
        item << (link_to "Manage User Accounts", { :controller => 'experts', :topic_id => nil}, :class=>"users")
        item << (link_to "Snippets", { :controller => 'snippets', :topic_id => nil}, :class=>"snippets")
        item << (link_to "System", { :controller => 'system', :topic_id => nil}, :class=>"system")
      end 
    end
    item.join(' | ') 
  end
  
  # return a link to the given topic
  def topic_link(topic)
    link_to topic.title, topic_url(topic)
  end
  
  def topic_link_abbrev(topic)
    link_to(truncate(topic.title), topic_url(topic))
  end
  
  def subscribe_to_rss_link
    (link_to '<img src="/images/feed-icon-14x14.png" width="10" height="10" alt="Feed icon">', rss_url) +
       " " +
       (link_to 'RSS feed of topics', rss_url)  +
       " " +
       '(' + (link_to "?", about_feeds_url, {:title => 'What is rss?'}) + ')'
  end
  
  def smarty_markdown(text)
      BlueCloth.new(RubyPants.new((text)).to_html).to_html
  end
  
  def show_notice_if_closed
    content_tag(
      :h3,
      "The DialogSpace is Closed (#{link_to "manage", :controller => 'system', :action => 'on_off'})",
      :class => 'alert'
    ) unless Settings.open 
  end
  
  
  def breadcrumb_links(breadcrumb_trail=[])
    return unless breadcrumb_trail 
    separator = " <span>&rsaquo;</span> " # ' &raquo; '
    breadcrumb_trail.collect do |piece|
      case piece
      when String
        truncate(piece, 50)
      when Array
        link_to truncate(piece.first, 50), piece.last # TODO allow string URLs -or- hash of url_for parameters
      else
        raise ArgumentError
      end
    end.join(separator)
  end
  
end

