# TODO test that this is scopped to topic and user
class ViewerController < ApplicationController
  
  before_filter :load_support_material
  
  # display the frameset (header and rating on top, content on bottom)
  def index
    current_user.record_read_of @support_material
    @content_url = content_url 
    render :layout => false # don't use a layout, since it's a different doctype
  end
  
  def content
    send_file @support_material.full_filename, 
      :type => @support_material.content_type, 
      :disposition => 'inline'
  end

  def header
    @informative_rating = @support_material.informative_ratings.for_user(current_user)
    @convincing_rating  = @support_material.convincing_ratings.for_user(current_user)
  end
  
 private
   
  def load_support_material
    @support_material = SupportMaterial.find(params[:id])
    # TODO: move this logic into a model. SupportMaterialPolicy?
    raise ActiveRecord::RecordNotFound if (@support_material.topic.for_future? && !current_user.has_permission_to?(:see_future_topic)) || (!@support_material.topic.approved? && !current_user.has_permission_to?(:see_held_topic))    
  end

  # returns a url for this support material, either being a remote url (if a url is found) or
  # a link to the local file
  def content_url
    @support_material.url.blank? ? (url_for :action => 'content', :id => @support_material) : @support_material.url
  end

end
