class UsersController < ApplicationController
  layout :admin_or_application_layout
  
  before_filter :permision_required, :set_breadcrumb
  
  # TODO break up into Admin controller and user friendly controller

  def index
    @klass = klass_from_type_param
    
    @users = @klass.find(:all) # TODO this should be paginated
    
    @count_participants = Participant.count
    @count_experts      = Expert.count
    @count_admins       = Admin.count
    @count_all          = RegisteredUser.count
    
    @title = "Manage User Accounts"
  end
  
  # 
  def new
    @user = klass_from_type_param(Participant).new(params[:user])
    return unless request.post?
    if @user.save
      redirect_to :action => 'index'
      flash[:notice] = "#{@user.class} Account Created"
    end
  end
  
  def edit
    @title = "Manage User Accounts"
    @user = RegisteredUser.find(params[:id])
    @user.password = ''
    @user.attributes = params[:user]
    return unless request.post?
    if @user.save
      redirect_to :action => 'index'
      flash[:notice] = "#{@user.class} Account Updated"
    end
  end
  
  def toggle
    @user = RegisteredUser.find(params[:id])
    unless params[:suspended].nil?
      if @user == current_user
        flash[:alert] = "cannot suspend your own account"
        redirect_to :action => 'edit', :id => @user.id
      end
      @user.update_attribute(:suspended, params[:suspended])
      flash[:notice] = @user.suspended? ? "User has been suspended" : "User no longer suspended"
    end
    
    unless params[:verified].nil?
      @user.update_attribute(:verified, 1) 
      flash[:notice] = "Email marked as verified"
    end
    
    redirect_to :action => 'edit', :id => @user.id
  end

  def show
    RegisteredUser.__rails_cannot_find_descendants_fix
    @profile          = RegisteredUser.find(params[:id])
    @commented_topics = current_user.commented_topics_by(@profile)
    
    @my_account       = Snippet.find_or_create_by_name('my_account')
    @sidebar          = Snippet.find_or_create_by_name('my_account_sidebar')
    set_default_breadcrumb
    @breadcrumb_trail << "Profile: %s" % @profile.name 
  end

  def change_message_prefs
    if current_user.update_attribute(:receive_messages_from_participants, params[:opt_in])
      flash[:notice] = "preference updated"
    end
    redirect_to profile_url(current_user)
  end
  
  # send an email reminder of the users password
  def remind_password
    user = User.find(params[:id])
    UserNotifier.deliver_password_reminder(user)
    flash[:notice] = "password has been sent to #{user.email}"
    redirect_to :action => 'edit', :id => user.id
  end
  
  private
  
  # Does the current action require any specific permission?
  def action_requires_permission?
    !['show', 'change_message_prefs'].include?(action_name)
  end
  
  def klass_from_type_param(default = RegisteredUser)
    case params[:type]
    when 'participant':
      Participant
    when 'expert':
      Expert
    when 'admin':
      Admin
    else
      default
    end
  end
end
