;
; Plots theoretical AR(K) spectra of the various models used to
; fit to the Mann et al. errors, checking for weird peaks/troughs.
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=3,ncol=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
def_1color,20,color='red'
def_1color,21,color='green'
def_1color,22,color='deepblue'
def_1color,23,color='orange'
;
ylog=1
yr=[0.01,0.5]
;
wstep=0.001
nw=round(0.5/wstep)+1
print,wstep,nw,wstep*(nw-1)
w=findgen(nw)*wstep
;
; Do AD1000 errors first
;
print
print,'AD1000'
arlin=[0.12756,  0.10542,  0.08702,  0.07166,  0.05874,  0.04779,  0.03841,  0.03027, $
  0.02309,  0.01664,  0.01070,  0.00507, -0.00041, -0.00592, -0.01163, -0.01773, $
 -0.02435, -0.01473, -0.00777, -0.00286,  0.00048,  0.00262,  0.00384,  0.00437, $
  0.00439,  0.00404,  0.00344,  0.00268,  0.00182,  0.00093,  0.00009, -0.00065, $
 -0.00121, -0.00151, -0.00145, -0.00118, -0.00082, -0.00044, -0.00009,  0.00022]
x=tjo_arspec(arlin,w,noisevar=0.2250^2)
print,sqrt(total(x)*wstep*2.)
plot,w,x,thick=2,ylog=ylog,yrange=yr,/ystyle
;
x=tjo_arspec([0.312],w,noisevar=0.2217^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=20
;
x=tjo_arspec([0.450],w,noisevar=0.2095^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=21
;
x=tjo_arspec([0.277,0.128],w,noisevar=0.2167^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=22
;
x=tjo_arspec([0.245,0.260],w,noisevar=0.2156^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=23
;
oplot,!x.crange,replicate(0.2319^2,2),linestyle=1
;
legtxt=['AR(1)','AR(1)fit','AR(2)','AR(2)fit','AR(40)linear']
legpos=[0.25,0.93]
legend,legtxt,thick=replicate(2,5),color=[20,21,22,23,!p.color],$
  position=legpos
;
; Do AD1400 errors next
;
print
print,'AD1400'
arlin=[0.16068,  0.12824,  0.10245,  0.08183,  0.06524,  0.05177,  0.04073,  0.03155,$
  0.02377,  0.01703,  0.01102,  0.00546,  0.00011, -0.00526, -0.01090, -0.01706,$
 -0.02401, -0.03490, -0.01898, -0.00811, -0.00090,  0.00364,  0.00625,  0.00748,$
  0.00776,  0.00738,  0.00655,  0.00543,  0.00414,  0.00276,  0.00137,  0.00004,$
 -0.00118, -0.00220, -0.00292, -0.00321, -0.00274, -0.00189, -0.00092,  0.00004]
x=tjo_arspec(arlin,w,noisevar=0.2109^2)
print,sqrt(total(x)*wstep*2.)
plot,w,x,thick=2,ylog=ylog,yrange=yr,/ystyle
;
x=tjo_arspec([0.325],w,noisevar=0.2138^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=20
;
x=tjo_arspec([0.619],w,noisevar=0.1796^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=21
;
x=tjo_arspec([0.247,0.268],w,noisevar=0.2024^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=22
;
x=tjo_arspec([0.186,0.470],w,noisevar=0.1921^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=23
;
oplot,!x.crange,replicate(0.2246^2,2),linestyle=1
;
legtxt=['AR(1)','AR(1)fit','AR(2)','AR(2)fit','AR(40)linear']
legpos=[0.75,0.93]
legend,legtxt,thick=replicate(2,5),color=[20,21,22,23,!p.color],$
  position=legpos
;
; Do AD1600 errors next
;
print
print,'AD1600'
x=tjo_arspec([0.170],w,noisevar=0.1922^2)
print,sqrt(total(x)*wstep*2.)
plot,w,x,/nodata,ylog=ylog,yrange=yr,/ystyle
oplot,w,x,thick=2,color=20
;
x=tjo_arspec([0.181],w,noisevar=0.1908^2)
print,sqrt(total(x)*wstep*2.)
oplot,w,x,thick=2,color=21
;
oplot,!x.crange,replicate(0.1938^2,2),linestyle=1
;
legtxt=['AR(1)','AR(1)fit']
legpos=[0.25,0.59]
legend,legtxt,thick=replicate(2,2),color=[20,21],$
  position=legpos
;
end
