;
; Computes the difference between the Mann et al. (1998) NH temperature
; reconstruction and the observed NH temperature, for the period
; 1902-1980.  These are the calibration residuals, for the "full" proxy
; network (i.e. representing the 1820 network).  Checks are made
; by computing correlation and RE values.  To ensure closest
; reproduction of the Mann et al. residuals, I'm using observed NH
; temperature from a file that Mike Mann provided.
; The calibration residuals are output for later analysis.
;
; First let's read in the NH temperature reconstruction and the 
; observed temperature
;
yrst=1902
yren=1980
nyr=yren-yrst+1
headst=strarr(1901-1400+1+1)
rawdat=fltarr(3,nyr)
openr,1,'mann_nh1400.dat'
readf,1,headst
readf,1,rawdat,format='(I6,2F11.7)'
close,1
;
timey=reform(rawdat[0,*])
rects=reform(rawdat[1,*])
obsts=reform(rawdat[2,*])
errts=rects-obsts
;
multi_plot,nrow=3
loadct,39
;
plot,timey,obsts,/xstyle
oplot,timey,rects,color=240
oplot,!x.crange,[0,0],linestyle=1
;
plot,timey,errts,/xstyle
oplot,!x.crange,[0,0],linestyle=1
;
r=correlate(obsts,rects)
print,'r and r^2:',r,r^2
re=1.-variance(errts)/variance(obsts)
print,'RE',re
;
openw,1,'nh-ad1820-resid.dat'
for i = 0 , nyr-1 do begin
  printf,1,timey[i],errts[i],-999.9,-999.9,format='(I6,3F12.4)'
endfor
close,1
;
end
