;
; Gets MXD or TRW from IDL save file and outputs it as an ascii file with all
; metadata too
;
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
endcase
;
restore,filename='all'+fnadd+'.idlsave'
tree=strtrim(tree)
idno=strtrim(idno)
idname=strtrim(idname)
location=strtrim(location)
country=strtrim(country)
;
missval=-9.99
ml=where(finite(mxd) eq 0,nmiss)
if nmiss gt 0 then mxd(ml)=missval
;
openw,1,'schweingruber_mxd.dat'
printf,1,transpose(mxd),format='(387F8.3)'
close,1
;
openw,1,'all'+fnadd+'.dat'
printf,1,'Schweingruber et al. tree-ring network'
printf,1,'File created by Tim Osborn (t.osborn@uea.ac.uk)'
printf,1,'Tree-ring variable is '+fnadd+' (mxd=maximum latewood density, trw=total ring width)'
printf,1
printf,1,nyr,format='(I8,"  : Number of years")'
printf,1,nchron,format='(I8,"  : Number of chronologies")'
printf,1,missval,format='(F8.3,"  : Missing value")'
printf,1,'Years'
printf,1,timey,format='(10I8)'
printf,1,'Chronologies (info, '+fnadd+' and fraction of cores with data)'
for i = 0 , nchron-1 do begin
  printf,1,"     Lat     Lon Genus   IDnum    IDname                      Location Country'
  printf,1,statlat(i),statlon(i),tree(i),idno(i),idname(i),location(i),$
    country(i),format='(2F8.2,A6,A8,A10,A30,A8)'
  printf,1,reform(mxd(*,i)),format='(10F8.3)'
  printf,1,reform(fraction(*,i)),format='(10F8.3)'
endfor
close,1
;
end
