;
; Plots the observed SLP, TEMP and PREC signals that go with the OLAT
; modes.  The signals are the regression coefficients between SLP
; anomalies, TEMP anomalies and PREC % anomalies, and the normalised (over
; 1961-90) principal component timeseries of each mode.
; IT IS THE CORRELATION NOT REGRESSION COEFF.
;
; Restore NOAA mode summer timeseries and station-based summer NAO
;
restore,filename='noaa_summer.idlsave'
;  nsummer,summerind,summerts,summertslow,timey
noaayr=timey
restore,filename='nao_summer.idlsave'
;  timey,seasts,tslow
naoyr=timey
summernao=seasts
;
restore,filename='olat_modes.idlsave'
mxdyear=timey
g={ nx: nx, ny:ny, x: xlon, y: ylat }
;
restore,filename='olat_stp_modes.idlsave'
;  slparp,temparp,precarp,modets,timey,nyr,nvar,varname
;  gslp,gtemp,gprec,nretain,instrts
;
loadct,39
multi_plot,nrow=2,ncol=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,bold=1,font_size=12
endelse
;
map=def_map(/npolar) & map.limit(0)=15.
labels=def_labels(/off)
sm=def_sm() & sm.thresh=0.1
coast=def_coast(/get_device) & coast.double=0 & coast.fill=1
coast.fillcolor=10
def_1color,10,color='vvlgreen'
def_1color,20,color='deepblue'
def_1color,21,color='red'
;
nretain=8
for iretain = 0 , nretain-1 do begin
  titn=string(iretain+1,format='(I2)')
  ;
  ; Timeseries first
  ;
  !p.multi=[0,1,2,0,0]
  pause
  yyy=reform(modets(*,iretain))
  ytem=reform(instrts(1,iretain,*))
  yslp=reform(instrts(0,iretain,*))
  mknormal,ytem
  plot,mxdyear,yyy,$
    /xstyle,xtitle='Year',$
    ytitle='Normalised amplitude',ymargin=[4,10],$
    title='(a) Land air temperature EOF Mode #'+titn
  oplot,!x.crange,[0.,0.],linestyle=1
  filter_cru,10.,/nan,tsin=ytem,tslow=tslow
;  oplot,mxdyear,ytem,linestyle=1,color=21
  oplot,mxdyear,tslow,thick=5,color=21
  filter_cru,10.,/nan,tsin=yyy,tslow=tslow
  oplot,mxdyear,tslow,thick=5
  ypos=!y.crange(0)+0.1*(!y.crange(1)-!y.crange(0))
  ypos2=!y.crange(0)+0.05*(!y.crange(1)-!y.crange(0))
  oplot,[1922,!x.crange(1)],[ypos,ypos],color=21,thick=6
  oplot,[1856,!x.crange(1)],[ypos2,ypos2],color=21,thick=6,linestyle=1
  print,mkcorrelation(yyy,ytem),mkcorrelation(yyy,yslp)
  ;
  ; Now plot SLP pattern
  ;
  fd=reform(slparp(*,*,iretain))
  levs=findgen(9)*0.1+0.1
  levs=[-reverse(levs),levs]
  nlev=n_elements(levs)
  c_labels=replicate(1,nlev)
  c_thick=[5,5,5,5,5,5,5,5,2,2,5,5,5,5,5,5,5,5]
  c_colors=[replicate(20,9),replicate(21,9)]
  sm.on=1
  ;
  !p.multi=[2,2,2,0,0]
  inter_confd,fd,gslp.xlon,gslp.ylat,$
    coast=coast,map=map,labels=labels,sm=sm,$
    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
    miss_grey='white',c_colors=c_colors
  ;
  !p.ticklen=0.03
  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
  yr=!y.region
  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
  xloc=0.5*total(!x.region)
  xyouts,xloc,yloc,/normal,align=0.5,$
    '(b) Mode #'+titn+' vs. SLP anomalies'
  yloc=yr(0)+0.1*(yr(1)-yr(0))
  xyouts,xloc,yloc,/normal,align=0.5,$
    'Correlations'
  ;
  ; Now plot TEMP pattern
  ;
  fd=reform(temparp(*,*,iretain))
  sm.on=1
  ;
  inter_confd,fd,gtemp.xlon,gtemp.ylat,$
    coast=coast,map=map,labels=labels,sm=sm,$
    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
    miss_grey='white',c_colors=c_colors
  ;
  ; Overplot the MXD EOF itself, as coloured circles of different sizes
  ;
  oneev=reform(ev(*,*,iretain),g.nx,g.ny)
  for ix = 0 , g.nx-1 do begin
    for iy = 0 , g.ny-1 do begin
      if finite(oneev(ix,iy)) then begin
        iloc=g.x(ix)
        jloc=g.y(iy)
        zval=oneev(ix,iy)
        if zval ge 0 then zcol=21 else zcol=20
        cpl_usersym,/circle,/fill
        map_plots,iloc,jloc,psym=8,color=zcol,symsize=abs(zval)*7.
        cpl_usersym,/circle
        map_plots,iloc,jloc,psym=8,symsize=abs(zval)*7.
      endif
    endfor
  endfor
  ;
  !p.ticklen=0.03
  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
  yr=!y.region
  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
  xloc=0.5*total(!x.region)
  xyouts,xloc,yloc,/normal,align=0.5,$
    '(c) Mode #'+titn+' vs. temperature anomalies'
  yloc=yr(0)+0.1*(yr(1)-yr(0))
  xyouts,xloc,yloc,/normal,align=0.5,$
    'Correlations'
  ;
  ; Now plot PREC pattern
  ;
;  fd=reform(precarp(*,*,iretain))
;  levs=findgen(8)*0.1+0.1
;  levs=[-reverse(levs),levs]
;  nlev=n_elements(levs)
;  c_labels=replicate(1,nlev)
;  c_thick=[replicate(2.,nlev/2),replicate(5.,nlev/2)]
;  c_colors=[replicate(!p.color,(nlev/2)-1),20.]
;  c_colors=[c_colors,reverse(c_colors)]
;  sm.on=1
  ;
;  inter_confd,fd,gprec.xlon,gprec.ylat,$
;    coast=coast,map=map,labels=labels,sm=sm,$
;    levels=levs,c_thick=c_thick,c_labels=c_labels,/follow,/hi_on,$
;    miss_grey='white',c_colors=c_colors
  ;
;  !p.ticklen=0.03
;  lon_polar,map=map,[-150.,-120,-60,-30,30,60,120,150],/dotick
  ;
;  normtop=convert_coord(map.limit(1),map.limit(0),/data,/to_normal)
;  yr=!y.region
;  yloc=normtop(1)+0.3*(yr(1)-normtop(1))
;  xloc=0.5*total(!x.region)
;  xyouts,xloc,yloc,/normal,align=0.5,$
;    'Mode #'+titn+' vs. precipitation anomalies'
;  xyouts,xloc,yr(0),/normal,align=0.5,$
;    'Correlations',charsize=!p.charsize*0.7
  ;
endfor
;
end
