pro maps_general,yrlist,nmaps=nmaps,doinfill=doinfill,doabd=doabd,$
  noscale=noscale, composite=composite,wantnmap=wantnmap,oldpage=oldpage
;
; Plots one or more yearly map(s) of calibrated (PCR-infilled or not) MXD
; reconstructions of growing season temperatures.  Uses "corrected" MXD - so
; shouldn't usually plot past 1960 because these will be artificially adjusted
; to look closer to the real temperatures.  If doabd is set, then it uses the
; (infilled or not) gridded calibrated data that have had their low-frequencies
; adjusted to match the ABD regional series.
; The default is to use the non-ABD data that has not been PCR-infilled.
;
; yrlist can be a list of n values, resulting in those years being plotted.
; Or it can be a single value, in which case just that year is plotted - unless
; nmaps is set >1, in which case nmaps will be plotted beginning with the year
; given by yrlist.
;
; If composite is set, then all individual maps are instead averaged into
; one composite mean.  Composite should be set to the title to be plotted on
; the composite map.  Use composite=' ' to get an untitled composite!
;
; If noscale is set, then no color scale is drawn (though if noscale>1 then a
; space for a color scale is left.  If noscale is set to -1,
; then the map is drawn with no color scale, but a colour scale is drawn
; in a separate window if X-windows is the current device.
;
; The layout is determined according to the number of maps that are requested.
; This may be over-ridden by wantnmap, which could (e.g.) allow extra places
; for later calls to this procedure with oldpage set to indicate that a new
; layout should *not* be started!
;
if n_elements(doabd) eq 0 then doabd=0
if n_elements(doinfill) eq 0 then doinfill=0
;
if n_elements(nmaps) eq 0 then nmaps=6
;
if not keyword_set(noscale) then noscale=0
;
nlist=n_elements(yrlist)
if nlist eq 0 then begin
  ndo=nmaps > 1
  yrdo=1800+indgen(ndo)
endif else begin
  if nlist eq 1 then begin
    if n_elements(nmaps) eq 0 then begin
      ndo=1
      yrdo=[yrlist]
    endif else begin
      ndo=nmaps > 1
      yrdo=yrlist[0]+indgen(ndo)
    endelse
  endif else begin
    ndo=n_elements(yrlist)
    yrdo=yrlist
  endelse
endelse
print,ndo
print,yrdo
declist=where(yrdo gt 1960,ndec)
if ndec gt 0 then message,'Plotting into the decline period!'
;
ncomp=ndo
if keyword_set(composite) then ndo=1
;
; Now lets choose a layout
;
if not keyword_set(oldpage) then begin
if n_elements(wantnmap) eq 0 then wantnmap=ndo
case wantnmap of
  1: rowcol=[1,1]
  2: rowcol=[2,1]
  4: rowcol=[2,2]
  6: rowcol=[3,2]
  12: rowcol=[4,3]
  15: rowcol=[5,3]
  20: rowcol=[5,4]
  24: rowcol=[6,4]
endcase
endif else begin
 rowcol=!p.multi[[2,1]]
 print,'ROWCOL',rowcol
 wantnmap=rowcol[0]*rowcol[1]
endelse
labsize=1
if wantnmap lt 6 then labsize=1.5
if wantnmap lt 4 then labsize=2.
scrsiz=[640,750]
paplay='large'
if wantnmap lt 2 then begin
  paplay='centred'
  scrsiz=[300,380]
  if noscale eq 1 then scrsiz=[300,300]
endif
;
xspan=1./float(rowcol[1])
if !d.name eq 'PS' then ykey=0.06 else ykey=0.1
if noscale eq 1 then ykey=0.
if rowcol[0] ge 6 then yover=0.04 else yover=0.
yspan=(1.+(rowcol[0]-1)*yover-ykey)/float(rowcol[0])
;
; Get the calibrated data
;
if doabd eq 0 then begin
  if doinfill eq 0 then begin
    restore,'calibmxd5.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
  endif else begin
    restore,'calibmxd5_pcr.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibc,timey,fdseas
  endelse
endif else begin
  if doinfill eq 0 then begin
    restore,'../mann/calibmxd5_abdlow.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu
  endif else begin
    restore,'../mann/calibmxd5_abdlow_pcr.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu
  endelse
endelse
;
; Now prepare for plotting
;
if not keyword_set(oldpage) then begin
loadct,39
multi_plot,nrow=rowcol[0],ncol=rowcol[1],layout=paplay
if !d.name eq 'X' then begin
  window,xsize=scrsiz[0],ysize=scrsiz[1]
  !p.font=-1
  if wantnmap lt 6 then !p.charsize=!p.charsize*1.5
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=11
  if wantnmap lt 2 then device,ysize=20.
endelse
def_1color,20,color='palepurple'
def_1color,21,color='lpurple'
def_1color,22,color='deepblue'
def_1color,23,color='mlblue'
def_1color,24,color='vlblue'
def_1color,25,color='vvlgreen'
def_1color,26,color='lsand'
def_1color,27,color='orange'
def_1color,28,color='red'
def_1color,29,color='dred'
 ileft=rowcol[0]*rowcol[1]
endif else begin
 ileft=!p.multi[0]
endelse
ioff=rowcol[0]*rowcol[1]-ileft
print,'ILEFT',ileft
;
; Define map parameters
;
map=def_map(/npolar) & map.limit(0)=25 & map.xmargin=[0,0] & map.ymargin=[0,0]
labels=def_labels(/off)
coast=def_coast(/get_device) & coast.thick=[0.5,2.5]
levs=[-100,-2,-1.2,-0.8,-0.4,-0.2,0,0.3,0.6,1,100]
cols=indgen(10)+20
xang=findgen(361)*!dtor
xcir=sin(xang)
ycir=cos(xang)
;
;ist=where(mxdyear eq yrstart)
;ist=ist(0)
;
;for i = 0 , ndo-1 do begin
for i = ndo-1 , 0 , -1 do begin
  ;
  if keyword_set(composite) then begin
   for iii = 0 , ncomp-1 do begin
    iyr=where(mxdyear eq yrdo[iii])
    if iii eq 0 then fd=reform(fdcalibc(*,*,iyr)) $
                else fd=fd+reform(fdcalibc(*,*,iyr))
   endfor
   fd=fd/float(ncomp)
   mtit=composite
  endif else begin
   iyr=where(mxdyear eq yrdo[i])
   mtit=string(mxdyear(iyr),format='(I4)')
  endelse
  ;
  ix=(i+ioff) mod rowcol[1]
  iy=rowcol[0]-1-(i+ioff/rowcol[1])
  ;
  ix=ix*xspan
  iy=ykey+iy*(yspan-yover)
  !p.position=[ix,iy,ix+xspan,iy+yspan]
  ;
  !p.multi(0)=1
  plot,[-1,1],[-1,1],/nodata,xstyle=5,ystyle=5,xmargin=[0,0],ymargin=[0,0]
  polyfill,xcir,ycir,color=!p.background
  !p.multi(0)=1
  inter_boxfd,fd,g.x,g.y,$
    coast=coast,map=map,labels=labels,$
    levels=levs,c_colors=cols
  xyouts,-47,28,mtit,charsize=labsize
  ;
endfor
!p.position=[0,0,0,0]
;
if noscale eq 0 then begin
  !p.multi[0]=1
  if !d.name eq 'PS' then begin
    if wantnmap lt 2 then !p.position=[0.15,0.015,0.85,ykey-0.015] $
                else !p.position=[0.30,0.015,0.70,ykey-0.015]
  endif else begin
    if wantnmap lt 6 then begin
      !p.charsize=!p.charsize/1.5
      !p.position=[0.15,0.035,0.85,ykey-0.025]
    endif else begin
      !p.position=[0.3,0.035,0.7,ykey-0.025]
    endelse
  endelse
  scale_horiz,levels=levs,c_colors=cols,noextremes=['Below','Above'],$
    title='!Uo!NC wrt 1961-90'
endif
!p.multi[0]=ileft-ndo
!p.position=[0,0,0,0]
print,'ILEFT',!p.multi[0]
;
  if (noscale eq -1) and (!d.name eq 'X') then begin
    window,2,xsize=300,ysize=70
    !p.multi=[0,0,0,0,0]
    !p.charsize=1.
    scale_horiz,levels=levs,c_colors=cols,noextremes=['Below','Above'],$
      title='!Uo!NC wrt 1961-90',xmargin=[3,3],ymargin=[2,2]
  endif
;
end
