;
;
; Get chronology locations
;
print,'Reading MXD data'
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
;
multi_plot,nrow=2
loadct,39
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
loadct,39
def_1color,20,color='lsand'
def_1color,40,color='dred'
def_smearcolor,fromto=[20,40]
;
nlen=yrend-yrstart+1
isort=reverse(sort(nlen))
;
plot,[0,1],/nodata,$
  /xstyle,xrange=[1400,2000],xtitle='Year',$
  /ystyle,yrange=[-5,400],ytitle='Chronology'
;
for i = 0 , nchron-1 do begin
  j=isort(i)
  icol=((nlen(j)-100)/30)+20
  icol=(icol > 20) < 40
  plots,[yrstart(j) > 1400,yrend(j)],[i,i],thick=1,color=icol
endfor
;
end
