;
; Plots correlations between regional temperatures and regional MXD series
; based on varying numbers of stations, for a range of fixed grids.
;
allfy=[1400,1500,1600,1700,1800,1950,1988]
nfixed=n_elements(allfy)
;
for trv = 0 , 1 do begin
;
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
endcase
titadd=strupcase(fnadd)
;
for i = 0 , nfixed-1 do begin
  ;
  restore,filename='regbest_'+fnadd+'_fixed'+string(allfy(i),format='(I4)')+'.idlsave'
  ;  nreg,regname,nsites,regr,locr,bestx,besty,bestmxd,regtemp,timey
  ;  fixedyr,corrper,doreg,maxntree
  ;
  if i+trv eq 0 then begin
    alllr=fltarr(maxntree,nreg,nfixed)
    allrr=fltarr(maxntree,nreg,nfixed)
    allpos=fltarr(nreg,3,nfixed)
    rpos=fltarr(nreg,3,nfixed,3,2)      ; nreg, 3=all,>0.22,best, nfixed, 3=raw,hi,low
  endif
  ;
  alllr(*,*,i)=locr(*,*)
  allrr(*,*,i)=regr(*,*,0)
  allpos(*,0,i)=(nsites(*)-1) > 0
  allpos(*,1,i)=(cutsites(*)-1) > 0
  for j = 0 , nreg-1 do begin
    dummy=max(regr(*,j,0),/nan,dum2)
    allpos(j,2,i)=dum2
    rpos(j,0,i,*,trv)=regr(allpos(j,0,i),j,*)
    rpos(j,1,i,*,trv)=regr(allpos(j,1,i),j,*)
    rpos(j,2,i,*,trv)=regr(dum2,j,*)
  endfor
  ;
endfor
;
endfor
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=5,ncol=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
def_1color,20,color='red'
def_1color,21,color='green'
def_1color,22,color='blue'
def_1color,23,color='black'
def_1color,30,color='red'
def_1color,31,color='deepblue'
;
xval=[1400,1500,1600,1700,1800,1900,1983,1994]
iuse=[0,1,2,3,4,5,5,6]
for ireg = 0 , nreg-1 do begin
  ;
  plot,[0,1],/nodata,$
    xstyle=1,xrange=[1400,1994],xtitle='Year of fixed grid',$
    ystyle=1,yrange=[0.,1.],ytitle='Regional correlation',$
    title=regname(ireg)
  ;
  for j = 2 , 8 , 2 do oplot,!x.crange,replicate(j*0.1,2),linestyle=1
  ;
for trv = 0 , 1 do begin
  lsym=[10,19,18]
  for k = 1 , 2 do begin
    yval=reform(rpos(ireg,1,*,k,trv))
    yval=yval(iuse)
    oplot,xval,yval,thick=2,psym=-def_sym(lsym(k)),color=30+trv
  endfor
  ;
  lthi=[1,7,3]
  lsty=[0,0,2]
  for k = 1 , 1 do begin
    yval=reform(rpos(ireg,k,*,0,trv))
    yval=yval(iuse)
    oplot,xval,yval,thick=lthi(k),linestyle=lsty(k),color=30+trv
  endfor
endfor
  ;
endfor
;
plot,[0,1],xstyle=4,ystyle=4,/nodata
legend,['r(regional MXD,Apr-Sep temperature)',$
  'r(regional TRW,Jun-Aug temperature)',$
  'Raw correlations','High-pass','Low-pass'],$
  linestyle=[0,0,0,0,0],thick=[4,4,7,2,2],psym=-[0,0,0,19,18],$
  color=[30,31,30,30,30]
;
end
