;
; Plots the number of MXD chronologies with data versus time.
;
fnadd='mxd'
;
; Get chronology data
;
print,'Reading '+fnadd+' data'
restore,filename='all'+fnadd+'.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=4,layout='large'
if !d.name eq 'X' then begin
  window,ysize=700
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=18
endelse
;
nvst=total(finite(mxd),2)
plot,timey,nvst,$
  title='(a)',$
  /xstyle,xtitle='Year',$
  ytitle='Number of chronologies!Cwith data'
;
maskfrac=fraction
ml=where(finite(mxd) eq 0)
maskfrac[ml]=!values.f_nan
totval=total(maskfrac,2,/nan)
numval=total(finite(maskfrac),2)
plot,timey,totval/numval,$
  title='(b)',$
  /xstyle,xtitle='Year',$
  ytitle='Fraction of tree cores!Cwith data for those!Cchronologies that have data'
;
end
