;
; Plots scatter plot of MXD correlations against TRW correlations
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
!y.omargin=[0,5]
;
; Restore MXD correlations first
;
restore,filename='mxd_moncorr.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
mxdr=reform(allr(*,18,1))
;
; Now the TRW correlations
;
restore,filename='trw_moncorr.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
trwr=reform(allr(*,[18,20],1))
;
restore,filename='reg_mxdlists.idlsave'
;  ntree,treelist,nreg,regname
;
rsym=[1,6,4,7,15,16,17,20,21]
seastit='r(TRW,'+['Apr-Sep','Jun-Aug']+' temp.)'
for i = 0 , 1 do begin
  ;
  r1=correlate(mxdr,trwr(*,i))
  ;
  plot,[0,1],/nodata,$
    xstyle=1,xrange=[-0.5,1],xtitle='r(MXD,Apr-Sep temp.)',$
    ystyle=1,yrange=[-0.5,1],ytitle=seastit(i),$
    title='r ='+string(r1,format='(F6.2)')
  oplot,[-1,1],[0,0],linestyle=1
  oplot,[-1,1],[-1,1],linestyle=1
  oplot,[0,0],[-1,1],linestyle=1
  ;
  for k = 0 , nreg-1 do begin
    for j = 0 , ntree(k)-1 do begin
      itree=treelist(j,k)
      plots,mxdr(itree),trwr(itree,i),psym=def_sym(rsym(k)),$
        symsize=0.7
    endfor
  endfor
  ;
endfor
;
legend,pos=[0.25,1.],/horiz,$
  regname,psym=rsym
;
end
