;
; Plots maps of chronology locations in each defined region
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
restore,filename='reg_mxdlists.idlsave'
;
loadct,39
def_1color,20,color='green'
multi_plot,nrow=3,ncol=3,layout='large'
if !d.name eq 'X' then begin
  window,xsize=650,ysize=950
endif
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/off)
labels=def_labels(/off)
;
for i = 0 , nreg-1 do begin
  ;
  n=ntree(i)
  inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
    title=regname(i)+' (N='+string(n,format='(I3)')+')'
  map_continents,/coasts,color=!p.color,mlinethick=0.5
  ;
  x=statlon(treelist(0:n-1,i))
  y=statlat(treelist(0:n-1,i))
  cpl_usersym,/circle,/fill
  plots,x,y,psym=8,color=20,symsize=0.5
  cpl_usersym,/circle
  plots,x,y,psym=8,thick=2,symsize=0.5
  ;
endfor
;
end
