;
; Plot locations of instrumental data boxes for ALL region and
; those with sufficient data and with MXD sites in them
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=1,layout='large'
if !d.name eq 'X' then begin
  window,xsize=650,ysize=950
endif else begin
  device,xsize=15,xoffset=3
  device,ysize=24,yoffset=2
endelse
def_1color,40,color='white'          ; was lgreen
def_1color,41,color='deepblue'
def_1color,42,color='red'
;
; Define map projection
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device)  &  coast.double=0 & coast.coasts=1
labels=def_labels(/off)
;
; Get regional data of instrumental boxes
;
restore,filename='reg_mxdboxes.idlsave'
;  nreg,regname,boxlists,boxnumbs,g,boxregs,boxprec
;
; Get regional data of MXD sites
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
restore,filename='reg_mxdlists.idlsave'
;  ntree,treelist,nreg,regname
cpl_usersym,/circle
;
  ;
  fd1=total(boxlists,3,/nan)      ; boxes with MXD sites
  fd1=fd1/fd1
  ;
  fd2=total(boxtemp,3,/nan)       ; boxes within region
  fd2=fd2/fd2
  fd3=fd2+finite(fd1)
  mlist=where( (finite(fd1) ne 0) and (finite(fd2) eq 0),nmonly)
  if nmonly gt 0 then fd3(mlist)=3.
  ;
  inter_boxfd,fd3,g.x,g.y,map=map,coast=coast,labels=labels,$
    title='TEMPERATURE & MXD DATA',$
    levels=[0.5,1.5,2.5,3.5],c_colors=[40,41,42]
  x=statlon
  y=statlat
  plots,x,y,psym=8,thick=2,symsize=0.5,color=!p.background
  ;
end
