;
; Plot locations of instrumental data boxes in each region and
; those with sufficient data and with MXD sites in them
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=2,layout='large'
if !d.name eq 'X' then begin
  window,xsize=650,ysize=950
endif else begin
  device,xsize=15,xoffset=3
  device,ysize=24,yoffset=2
endelse
def_1color,40,color='lgreen'
def_1color,41,color='deepblue'
def_1color,42,color='red'
;
; Define map projection
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device)  &  coast.double=0 & coast.coasts=1
labels=def_labels(/off)
;
; Get regional data of instrumental boxes
;
restore,filename='reg_mxdboxes.idlsave'
;  nreg,regname,boxlists,boxnumbs,g,boxregs,boxprec
;
; Get regional data of MXD sites
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
restore,filename='reg_mxdlists.idlsave'
;  ntree,treelist,nreg,regname
cpl_usersym,/circle
;
for i = 0 , nreg-1 do begin
  ;
  pause
  ;
  fd1=boxlists(*,*,i)      ; boxes with MXD sites
  ;
  fd2=boxprec(*,*,i)       ; boxes within region
  fd3=fd2+finite(fd1)
  mlist=where( (finite(fd1) ne 0) and (finite(fd2) eq 0),nmonly)
  if nmonly gt 0 then fd3(mlist)=3.
  ;
  inter_boxfd,fd3,g.x,g.y,map=map,coast=coast,labels=labels,$
    title=regname(i)+': PRECIPITATION & MXD DATA',$
    levels=[0.5,1.5,2.5,3.5],c_colors=[40,41,42]
  n=ntree(i)
  x=statlon(treelist(0:n-1,i))
  y=statlat(treelist(0:n-1,i))
  plots,x,y,psym=8,thick=2,symsize=0.5,color=!p.background
  ;
  fd2=boxtemp(*,*,i)       ; boxes within region
  fd3=fd2+finite(fd1)
  mlist=where( (finite(fd1) ne 0) and (finite(fd2) eq 0),nmonly)
  if nmonly gt 0 then fd3(mlist)=3.
  ;
  inter_boxfd,fd3,g.x,g.y,map=map,coast=coast,labels=labels,$
    title=regname(i)+': TEMPERATURE & MXD DATA',$
    levels=[0.5,1.5,2.5,3.5],c_colors=[40,41,42]
  plots,x,y,psym=8,thick=2,symsize=0.5,color=!p.background
  ;
endfor
;
end
