;
; Plots changes in correlations between regional MXD and regional monthly &
; seasonal precip. and temperature.  Partial correlations for precip., full
; for temp.
;
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
endcase
titadd=strupcase(fnadd)
;
; Restore all correlations
;
restore,filename='reg'+fnadd+'_moncorr_early.idlsave'
;  allr,ncorr,nvar,nreg,regname,varname,corrname,allp,lowr,lowp,thalf
allr1=lowr
allp1=lowp
allr1=allr
allp1=allp
restore,filename='reg'+fnadd+'_moncorr_late.idlsave'
;  allr,ncorr,nvar,nreg,regname,varname,corrname,allp,lowr,lowp,thalf
allr2=lowr
allp2=lowp
allr2=allr
allp2=allp
restore,filename='reg'+fnadd+'_moncorr.idlsave'
;  allr,ncorr,nvar,nreg,regname,varname,corrname,allp,lowr,lowp,thalf
;
; Combine temp r with prec partial r
;
regr=lowr
regr=allr
regr(*,*,0)=allr(*,*,1)
regr(*,*,1)=allp(*,*,0)
varname=reverse(varname)
conname=['',' constant Temp']
yname=['Correlation','Partial correlation']
earr=allr1
earr(*,*,0)=allr1(*,*,1)
earr(*,*,1)=allp1(*,*,0)
latr=allr2
latr(*,*,0)=allr2(*,*,1)
latr(*,*,1)=allp2(*,*,0)
;
; Now generate three extra composite regions
;
newr=fltarr(nreg+3,ncorr,nvar)
newe=fltarr(nreg+3,ncorr,nvar)
newl=fltarr(nreg+3,ncorr,nvar)
newr(0:nreg-1,*,*)=regr(*,*,*)
newe(0:nreg-1,*,*)=earr(*,*,*)
newl(0:nreg-1,*,*)=latr(*,*,*)
regname=[regname,'HILAT','LOLAT','NH']
;
rlist=[0,2,3,7,8]
newr(nreg,*,*)=total(regr(rlist,*,*),1)/float(n_elements(rlist))
newe(nreg,*,*)=total(earr(rlist,*,*),1)/float(n_elements(rlist))
newl(nreg,*,*)=total(latr(rlist,*,*),1)/float(n_elements(rlist))
;
rlist=[1,4,5,6]
newr(nreg+1,*,*)=total(regr(rlist,*,*),1)/float(n_elements(rlist))
newe(nreg+1,*,*)=total(earr(rlist,*,*),1)/float(n_elements(rlist))
newl(nreg+1,*,*)=total(latr(rlist,*,*),1)/float(n_elements(rlist))
;
newr(nreg+2,*,*)=total(regr,1)/float(nreg)
newe(nreg+2,*,*)=total(earr,1)/float(nreg)
newl(nreg+2,*,*)=total(latr,1)/float(nreg)
;
regr=newr
earr=newe
latr=newl
nreg=nreg+3
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3,ncol=2,layout='caption'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='vlgrey'
def_1color,21,color='mgrey'
;
for i = 0 , nreg-1 do begin
  for ivar = 0 , nvar-1 do begin
    pause
    x=findgen(28)
    yy=reform(earr(i,*,ivar))
    y=fltarr(28)*!values.f_nan
    yloc=[indgen(16)+1,indgen(5)*2+18]
    y(yloc)=yy(*)
    plot,x,y,/nodata,$
      /ystyle,yrange=[-1.,1.],ytitle=yname(ivar),$
      xstyle=5,title=regname(i)+'  r('+titadd+','+varname(ivar)+')'+conname(ivar)
    for j = -10,10,2 do oplot,!x.crange,replicate(float(j)*0.1,2),linestyle=1
    oplot,!x.crange,[0.,0.]
    oplot,[7.5,7.5],!y.crange,thick=4
    cpl_barts,x,y,outline=-1,/overplot,bar_color=[21,20],thick=2
    if !d.name eq 'PS' then device,font_size=8
    for j = 0 , ncorr-1 do begin
      x1=x(yloc(j))
      y1ear=earr(i,j,ivar)
      y1lat=latr(i,j,ivar)
;      plots,x1,y1ear,psym=def_sym(6)
      plots,x1,y1lat,psym=def_sym(10)
      x1=x(yloc(j))+0.28
      y1=!y.crange(0)-0.05
      if !p.multi(0) le 1 then xyouts,x1,y1,corrname(j),align=1,orient=90.
    endfor
    xyouts,7.,-0.85,align=1.,'Previous!Cyear'
    xyouts,8.,-0.85,align=0.,'Same!Cyear'
    if !d.name eq 'PS' then device,font_size=14
  endfor
endfor
;
end
