;
; Plots long reconstructions (Age-banded, Jones, Mann(v2) and
; Yamal+Torne+Taimyr), and correlates them too!
;
docorr=0        ; 1=compute correlations  0=don't
thalf=50.       ; filter for high or low-pass
;
lcol=[15,15,15,15,15,15]
lthi=[3,3,3,3,3,6]
;
loadct,39
multi_plot,nrow=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=900
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,bold=0,font_size=14
endelse
def_1color,10,color='red'
def_1color,11,color='lpurple'
def_1color,12,color='mlblue'
def_1color,13,color='green'
def_1color,14,color='mdyellow'
def_1color,15,color='black'
;
ndo=6
nyr=2000
alltime=findgen(nyr)
alldo=fltarr(ndo,nyr)*!values.f_nan
namedo=['Jones ','Mann  ','Briffa','NChron','Overpeck','Instr']
iord=[3,0,1,2,4,5]
;
for jdo = 0 , 5 , 5 do begin
  ido=iord(jdo)
  fac=1.
  ;
  case ido of
    0: begin        ; Phil's reconstruction
      alltit="Jones' Northern Hemisphere temperature reconstruction"
      ; Period to consider
      perst=1000
      peren=1992
      openr,1,'../tree5/phil_nhrecon.dat'
      nyr=992
      rawdat=fltarr(4,nyr)
      readf,1,rawdat,format='(I5,F7.2,I3,F7.2)'
      close,1
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(3,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)
      ; Convert from normalised values to deg C relative to 1961-1990
;      ts=ts*0.521 -0.1134       ; via Phil's variance matching (vs. NH all)
      ts=ts*0.3856-0.1112       ; via regression vs. NH land>20
    end
    1: begin        ; Mike Mann's reconstruction (now use his 1000 yr one)
      alltit="Mann's Northern Hemisphere temperature reconstruction"
      ; Period to consider
      perst=1000
      peren=1980
      openr,1,'../tree5/mann_nhrecon1000.dat'
      nyr=981
      headdat=' '
      rawdat=fltarr(2,nyr)
;      readf,1,headdat
      readf,1,rawdat           ;,format='(I6,F11.7)'
      close,1
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(1,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
;      ts=ts(kl)-0.12            ; convert to oC wrt 1961-90 (vs. NH all)
      ts=ts(kl)*1.0641-0.0764   ; convert to oC wrt 1961-90 (vs. NH land>20)
    end
    2: begin        ; Age-banded MXD (non-variance corrected!)
      alltit="Age-banded density NH growing-season reconstruction"
      ; Period to consider
      perst=1550
      peren=1960
      restore,filename='../treeharry/densadj_all(330).idlsave'
      timey=x
          ; CONVERSION FACTORS FOR AGE-BANDED MXD, BY REGRESSION ON INSTR.
      ts=densall*0.151434    ; converts it from density to temperature anom
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)-0.139032    ; to convert it oC wrt 1961-90
    end
    3: begin         ; Torn+Yama+Taim
      perst=1
      peren=1993
      openr,2,'tornyamataim.ave'
      readf,2,nnn
      rawdat=fltarr(2,nnn)
      readf,2,rawdat
      close,2
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(1,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)*0.1342-0.2761    ; to convert it oC wrt 1961-90
      ;
    end
    4: begin         ; Overpeck
      perst=1600
      peren=1990
      fac=0.2        ; multiply filter by this because record is already 5-yrs
      openr,2,'overpeck_arctic.dat'
      headst=strarr(2)
      readf,2,headst
      readf,2,nnn
      rawdat=fltarr(2,nnn)
      readf,2,rawdat
      close,2
      timey=reverse(reform(rawdat(0,*)))
      ts=reverse(reform(rawdat(1,*)))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)*0.3352-0.0802    ; to convert it oC wrt 1961-90
      ;
    end
    5: begin         ; Instrumental NH land > 20N, Apr-Sep
      perst=1871
      peren=1997
      openr,2,'../treeharry/nhland20_amjjas.dat'
      readf,2,nnn
      rawdat=fltarr(2,nnn)
      readf,2,rawdat
      close,2
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(1,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)
      ;
    end
  endcase
  ;
  ; Now plot the results
  ;
  filter_cru,thalf*fac,/nan,tsin=ts,tslow=tslow
  ;
  if jdo eq 0 then begin
    plot,timey,tslow,/nodata,$
      xstyle=1,xrange=[0,2000],xtitle='Year  (AD)',$
      /ystyle,ytitle='Smoothed temperature anomaly  (!Uo!NC wrt 1961-90)',$
      yrange=[-0.55,0.25]
    oplot,!x.crange,[0.,0.],linestyle=1
  endif
  ;
  oplot,timey,tslow,thick=lthi(ido),color=lcol(ido)
  ;
  ; Store timeseries for later cross-correlation
  ;
  ist=where(alltime eq timey(0))
  alldo(ido,ist(0):ist(0)+n_elements(ts)-1)=ts(*)
  ;
endfor
;
if docorr ne 0 then begin
ndo=4
for kkk = 0 , 1 do begin
  if kkk eq 0 then yrst=1000 else yrst=1400
  print
  print,'Analysis period:',yrst,1960
  print
  print,'TS1     TS2          Raw   <50yr   >50yr'
for ido = 0 , ndo-2 do begin
  for jdo = ido+1 , ndo-1 do begin
    x=reform(alldo(ido,*))
    y=reform(alldo(jdo,*))
    allr=mkcorrelation(x,y,alltime,filter=thalf,refperiod=[yrst,1960])
    print,namedo(ido),namedo(jdo),allr,format='(2A8,3F8.2)'
  endfor
endfor
endfor
endif
;
end
