;
; From a slightly infilled monthly temperature data set, compute the fractional
; coverage that has **complete*** coverage for different periods, to enable
; a best period for PCA to be done.
;
print,'Getting monthly temperatures'
fn='obs_temp_mon.idlsave'
restore,filename=fn
; Get timey,fdmon,xlon,ylat,nyr,nx,ny
; fdltm,fdsd,landonly,seaonly,mainlysea,missfrac,nmon
;
loadct,39
multi_plot,nrow=3
if !d.name eq 'X' then window,ysize=850
;
print,'Defining arrays'
minper=48
nstep=1
ndo=nyr/nstep
nbox=fltarr(ndo,ndo)
nbox(*,*)=!values.f_nan
;
fdann=total(fdmon,3)
print,'Determining complete coverage'
for styr = 20 , nyr-minper , nstep do begin
  print,timey(styr),format='(I4)'
  for enyr = styr+minper-1 , nyr-1 , nstep do begin
    print,timey(enyr),format='($,I4)'
    fd1=fdann(*,*,styr:enyr)
    fd1=total(fd1,3)
    dummy=where(finite(fd1),num)
    nbox(enyr/nstep,styr/nstep)=num
  endfor
  print
endfor
;
fnout='nbox'+string(nstep,format='(I1)')+'.idlsave'
save,filename=fnout,nstep,ndo,timey,nbox,nx,ny,minper
;
end
