;
; Plots calibration statistics for the MXD against temperature.
; calibmxd4 has calibration done on both decline-corrected and uncorrected
; MXD data.  Statistics are for the corrected dataset only, and are
; artificially high for the calibration period, but are fine for the
; verification period.
; Infilling of regression coefficients is done, and then calibration applied
; to those boxes previously without coefficients.
;
restore,filename='calibmxd3.idlsave'
; Gets: fdcalib, fdcorrect (and other stuff!)
restore,filename='calibmxd4.idlsave'
; Gets:  g,mxdyear,mxdnyr,fdcorr,fdalph,fdbeta,fdvexp,mxdfd2,$
;        fdrver,fdvver,fdseas,timey,fdcalibu,fdcalibc
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=2
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
;
outfd=total(finite(mxdfd2),3)
list4=where(outfd eq 0)
list2=where(outfd gt 0)
outfd(list4)=4.
outfd(list2)=2.
;
map=def_map(/npolar) & map.limit(0)=25.
labels=def_labels(/off)
;
inter_boxfd,fdcorr,g.x,g.y,$
  labels=labels,map=map,$
  levels=[0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9],/scale,$
  title='Correlation over calibration period (CORRECTED)'
fdin={ fd: outfd, x: g.x, y: g.y, nx: g.nx, ny: g.ny }
whizz_fd,fdin=fdin,fdout=f,limit=map.limit
boxplot,f.fd,f.x,f.y,/overplot,/overmap,highlight=f.fd,thick=1.5
;
inter_boxfd,fdrver,g.x,g.y,$
  labels=labels,map=map,$
  levels=[0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9],/scale,$
  title='Correlation over verification period (CORRECTED)'
boxplot,f.fd,f.x,f.y,/overplot,/overmap,highlight=f.fd,thick=1.5
;
pause
inter_boxfd,fdvexp,g.x,g.y,$
  labels=labels,map=map,$
  levels=[-1,0,0.1,0.2,0.3,0.4,0.5,0.6,0.8],/scale,$
  title='% variance explained (calibration CORRECTED)'
boxplot,f.fd,f.x,f.y,/overplot,/overmap,highlight=f.fd,thick=1.5
;
inter_boxfd,fdvver,g.x,g.y,$
  labels=labels,map=map,$
  levels=[-1,0,0.1,0.2,0.3,0.4,0.5,0.6,0.8],/scale,$
  title='% variance explained (verification CORRECTED)'
boxplot,f.fd,f.x,f.y,/overplot,/overmap,highlight=f.fd,thick=1.5
;
pause
inter_boxfd,fdalph,g.x,g.y,$
  labels=labels,map=map,$
  levels=[-1.5,-1.,-0.5,-0.2,0.,0.2,0.5],/scale,$
  title='Regression constant (CORRECTED)'
boxplot,f.fd,f.x,f.y,/overplot,/overmap,highlight=f.fd,thick=1.5
;
inter_boxfd,fdbeta,g.x,g.y,$
  labels=labels,map=map,$
  levels=[0.4,0.6,0.8,1.0,1.2,1.4,1.6],/scale,$
  title='Regression slope (CORRECTED)'
boxplot,f.fd,f.x,f.y,/overplot,/overmap,highlight=f.fd,thick=1.5
;
; Now need to infill the 6 boxes without regression coefficients.  This is
; done using a gaussian-weighted mean of nearby coefficients.
;
print,'Infilling coefficients'
allx=fltarr(g.nx,g.ny)
for iy = 0 , g.ny-1 do allx(*,iy)=g.x(*)
ally=fltarr(g.nx,g.ny)
for ix = 0 , g.nx-1 do ally(ix,*)=g.y(*)
statx=allx(list2)
staty=ally(list2)
;
statval=fdalph(list2)
misslist=where(finite(statval) eq 0,nmiss)
if nmiss gt 0 then begin
  fd_extend,statval,statx,staty,search=1000.,wavelen=400.
  fdalph(list2(misslist))=statval(misslist)
endif
;
statval=fdbeta(list2)
misslist=where(finite(statval) eq 0,nmiss)
if nmiss gt 0 then begin
  fd_extend,statval,statx,staty,search=1000.,wavelen=400.
  fdbeta(list2(misslist))=statval(misslist)
endif
;
; Now plot the infilled coefficients
;
pause
inter_boxfd,fdalph,g.x,g.y,$
  labels=labels,map=map,$
  levels=[-1.5,-1.,-0.5,-0.2,0.,0.2,0.5],/scale,$
  title='Regression constant (CORRECTED & INFILLED)'
boxplot,f.fd,f.x,f.y,/overplot,/overmap,highlight=f.fd,thick=1.5
;
inter_boxfd,fdbeta,g.x,g.y,$
  labels=labels,map=map,$
  levels=[0.4,0.6,0.8,1.0,1.2,1.4,1.6],/scale,$
  title='Regression slope (CORRECTED & INFILLED)'
boxplot,f.fd,f.x,f.y,/overplot,/overmap,highlight=f.fd,thick=1.5
;
; Now compute the calibrated values now that all boxes have coefficients
;
for iyr = 0 , mxdnyr-1 do begin
  fdcalibu(*,*,iyr)=fdalph(*,*)+fdbeta(*,*)*fdcalib(*,*,iyr)
  fdcalibc(*,*,iyr)=fdalph(*,*)+fdbeta(*,*)*fdcorrect(*,*,iyr)
endfor
;
; Now save the data for later analysis
;
save,filename='calibmxd5.idlsave',$
  g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
;
end
