;
; Combines the directly calibrated MXD data set with the PCR-based
; reconstruction of gridded temperatures.  There are various PCR models to
; use, according to period and spatial coverage of MXD data.  We always
; use the later model (based on most MXD data), but we have to decide whether
; a grid box that was successfully reconstructed using an earlier subset of
; the MXD should be used throughout (or at all) if later subsets failed to
; successfully reconstruct it.  **For now, I'm using them throughout.**
;
; Restore MXD gridded dataset
;
print,'Reading in MXD data'
restore,filename='calibmxd5_abdlow.idlsave'
;  g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
;
; Use the "corrected" calibrated version
;
fdcalibpcr=fdcalibc
timeyr=mxdyear
nyr=mxdnyr
;
; Now process each PCR version in turn
;
for iper = 0 , 6 do begin
  ;
  case iper of
    0: perst='14001976'
    1: perst='14531976'
    2: perst='15831976'
    3: perst='16601976'
    4: perst='16971976'
    5: perst='17431976'
    6: perst='18221976'
  endcase
  ;
  ; Restore the next PCR-based reconstruction
  ;
  fn='calibmxd5_abdlow_pcr'+perst+'.idlsave'
  print,fn
  restore,filename=fn
  ; Gets: mxdyear,mxdnyr,nx,ny,xlon,ylat,fdstatus,recontemp
  ;
  ; Check that the grids match
  ;
  abserr=total(abs(g.x-xlon))
  if abserr ne 0. then message,'Grids do not match!'
  abserr=total(abs(g.y-ylat))
  if abserr ne 0. then message,'Grids do not match!'
  ;
  ; Identify period of overlap
  ;
  ist=where(timeyr eq mxdyear(0)) & ist=ist(0)
  ;
  ; Put in the reconstruction, replacing any data already there
  ;
  for iyr = 0 , mxdnyr-1 do begin
    fd=reform(recontemp(*,*,iyr))
    kl=where(finite(fd),nkeep)
    if nkeep gt 0 then begin
      oldfd=fdcalibpcr(*,*,ist+iyr)
      oldfd(kl)=fd(kl)
      fdcalibpcr(*,*,ist+iyr)=oldfd
    endif
  endfor
  ;
endfor
;
; Finally, replace the original calibrated MXD values, since these are
; preferable to the PCR-based reconstructions
;
kl=where(finite(fdcalibc))
fdcalibpcr(kl)=fdcalibc(kl)
;
; Now save the combined reconstruction data set
;
mxdyear=timeyr
mxdnyr=nyr
fdcalibc=fdcalibpcr
save,filename='calibmxd5_abdlow_pcr.idlsave'
;  g,mxdyear,mxdnyr,fdcalibc,timey,fdseas
;
end
