;
; For a specified period, counts how many monthly values are missing from
; a slightly infilled monthly temperature data set, and how many grid boxes
; have complete coverage.
;
print,'Getting monthly temperatures'
fn='obs_temp_mon.idlsave'
restore,filename=fn
; Get timey,fdmon,xlon,ylat,nyr,nx,ny
; fdltm,fdsd,landonly,seaonly,mainlysea,missfrac,nmon
;
loadct,39
multi_plot,nrow=4
if !d.name eq 'X' then window,ysize=850
def_1color,20,color='black'
def_1color,21,color='mgrey'
;
print,'Defining arrays'
if n_elements(styr) eq 0 then styr=1902
if n_elements(enyr) eq 0 then enyr=1980
missy=[1914,1915,1916]  ;,1917,1918]
nmiss=n_elements(missy)
ndo=enyr-styr+1
ioff=timey(0)
fd=fltarr(nx,ny)
;
iwant=indgen(ndo)+styr
if nmiss gt 0 then begin
  for i = 0 , nmiss-1 do begin
    iwant(where(iwant eq missy(i)))=-9999
  endfor
endif
kl=where(iwant gt 0,ndo)
iwant=iwant(kl)
print,iwant,format='(10I8)'
fdper=fdmon(*,*,*,iwant-ioff)
fdper=reform(fdper,nx,ny,nmon*ndo)
nummiss=total(1-finite(fdper),3)
dummy=where(nummiss eq 0,nfull)
fd(dummy)=fd(dummy)+1.
dummy=where(nummiss le 12,n1)
fd(dummy)=fd(dummy)+1.
dummy=where(nummiss le 60,n3)
fd(dummy)=fd(dummy)+1.
dummy=where(nummiss le 120,n5)
fd(dummy)=fd(dummy)+1.
print,styr,enyr
print,'NH boxes with full data = ',nfull
print,'NH boxes with <=12 months missing = ',n1
print,'NH boxes with <=60 months missing = ',n3
print,'NH boxes with <=120 months missing = ',n5
;
map=def_map() & map.limit(0)=0.
c=def_coast(/get_device) & c.double=0
inter_boxfd,fd,xlon,ylat,levels=[3.5,4.5,10],c_colors=[20,21],map=map,coast=c
inter_boxfd,fd,xlon,ylat,levels=[2.5,3.5,10],c_colors=[20,21],map=map,coast=c
inter_boxfd,fd,xlon,ylat,levels=[1.5,2.5,10],c_colors=[20,21],map=map,coast=c
inter_boxfd,fd,xlon,ylat,levels=[0.5,1.6,10],c_colors=[20,21],map=map,coast=c
;
end
