function ivanov,tmon,rmon,vapour=vapour
;
; Given twelve monthly (Jan-Dec) temperatures (absolute values in degrees C),
; and twelve monthly relative humidities (0-100 %), this function returns
; twelve monthly potential evapotranspiration values according to the Ivanov
; formula.  If /vapour is set, then rmon should contain twelve monthly
; vapour pressures (hPa), which will be converted to relative humidities
; within the routine.
;
; Check input data
;
nmon=12
if n_elements(tmon) ne nmon then message,'Provide 12 monthly temperatures'
if n_elements(rmon) ne nmon then $
  message,'Provide 12 monthly relative humidities'
;
if keyword_set(vapour) eq 0 then begin
  rhmon=rmon
endif else begin
  satvap=6.1078*exp(17.2693882*tmon/(tmon+273.16-35.86))
  rhmon=100.*rmon/satvap < 100.
  print,rhmon,format='(12F6.1)'
endelse
;
pe = 0.0018 * ((tmon+25.)^2) * (100.-rhmon)
;
return,pe
end
