;
; Plots changes in correlations between regional MXD and regional monthly &
; seasonal precip. and temperature.  Partial correlations for precip., full
; for temp.
;
; Restore all correlations
;
restore,filename='regmxd_moncorr_early.idlsave'
;  allr,ncorr,nvar,nreg,regname,varname,corrname,allp,lowr,lowp,thalf
allr1=lowr
allp1=lowp
restore,filename='regmxd_moncorr_late.idlsave'
;  allr,ncorr,nvar,nreg,regname,varname,corrname,allp,lowr,lowp,thalf
allr2=lowr
allp2=lowp
restore,filename='regmxd_moncorr.idlsave'
;  allr,ncorr,nvar,nreg,regname,varname,corrname,allp,lowr,lowp,thalf
;
; Combine temp r with prec partial r
;
regr=allr
regr(*,*,0)=lowr(*,*,1)
regr(*,*,1)=lowp(*,*,0)
varname=reverse(varname)
conname=['',' constant Temp']
earr=allr1
earr(*,*,0)=allr1(*,*,1)
earr(*,*,1)=allp1(*,*,0)
latr=allr2
latr(*,*,0)=allr2(*,*,1)
latr(*,*,1)=allp2(*,*,0)
;
; Now generate three extra composite regions
;
newr=fltarr(nreg+3,ncorr,nvar)
newe=fltarr(nreg+3,ncorr,nvar)
newl=fltarr(nreg+3,ncorr,nvar)
newr(0:nreg-1,*,*)=regr(*,*,*)
newe(0:nreg-1,*,*)=earr(*,*,*)
newl(0:nreg-1,*,*)=latr(*,*,*)
regname=[regname,'HILAT','LOLAT','NH']
;
rlist=[0,2,3,7,8]
newr(nreg,*,*)=total(regr(rlist,*,*),1)/float(n_elements(rlist))
newe(nreg,*,*)=total(earr(rlist,*,*),1)/float(n_elements(rlist))
newl(nreg,*,*)=total(latr(rlist,*,*),1)/float(n_elements(rlist))
;
rlist=[1,4,5,6]
newr(nreg+1,*,*)=total(regr(rlist,*,*),1)/float(n_elements(rlist))
newe(nreg+1,*,*)=total(earr(rlist,*,*),1)/float(n_elements(rlist))
newl(nreg+1,*,*)=total(latr(rlist,*,*),1)/float(n_elements(rlist))
;
newr(nreg+2,*,*)=total(regr,1)/float(nreg)
newe(nreg+2,*,*)=total(earr,1)/float(nreg)
newl(nreg+2,*,*)=total(latr,1)/float(nreg)
;
regr=newr
earr=newe
latr=newl
nreg=nreg+3
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=2
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=10
endelse
def_1color,20,color='lblue'
def_1color,21,color='mred'
def_1color,22,color='orange'
!x.margin=[8,8]
!y.margin=[7,3]
;
for i = 9 , 9 do begin
  for ivar = 0 , nvar-2 do begin
    if ivar eq 1 then yta='Partial ' else yta=' '
    if ivar eq 0 then $
 ymt='Correlations between DENSITY and monthly/seasonal TEMPERATURES!C'+$
     'High-latitude regions!C1901-1950 (BARS)      1935-1984 (DOTS)' $
    else $
 ymt='Partial correlations between DENSITY and monthly/seasonal PRECIPITATION!C'+$
     'High-latitude regions!C1901-1950 (BARS)      1935-1984 (DOTS)'
ymt='(All time series decadally-filtered)!C'+ymt
    x=findgen(28)
    yy=reform(earr(i,*,ivar))
    y=fltarr(28)*!values.f_nan
    yloc=[indgen(16)+1,indgen(5)*2+18]
    y(yloc)=yy(*)
    plot,x,y,/nodata,$
      /ystyle,yrange=[-1.,1.],ytitle=yta+'Correlation',$
      xstyle=5,title=ymt
    if !d.name eq 'PS' then device,font_size=16
    for j = -10,10,2 do oplot,!x.crange,replicate(float(j)*0.1,2),linestyle=1
    oplot,!x.crange,[0.,0.]
    oplot,[7.5,7.5],!y.crange,thick=4
    oplot,[17.,17.],!y.crange,thick=4
    cpl_barts,x,y,outline=-1,/overplot,bar_color=[21,20],thick=2
    if !d.name eq 'PS' then device,font_size=12
    for j = 0 , ncorr-1 do begin
      x1=x(yloc(j))
      y1ear=earr(i,j,ivar)
      y1lat=latr(i,j,ivar)
;      plots,x1,y1ear,psym=def_sym(6)
      plots,x1,y1lat,psym=def_sym(10),symsize=1.4
      x1=x(yloc(j))+0.28
      y1=!y.crange(0)-0.05
      xyouts,x1,y1,corrname(j),align=1,orient=90.
    endfor
    xyouts,7.,-0.85,align=1.,'Previous!Cyear'
    xyouts,8.,-0.85,align=0.,'Same!Cyear'
    xyouts,17.5,-0.85,align=0.,'Seasons'
    if !d.name eq 'PS' then device,font_size=10
!y.margin=[3,7]
  endfor
endfor
;
end
