;
; Plots maps of correlations between MXD and Apr-Sep temperature and
; May-Aug precipitation.
;
do3=1           ; use 6 categories, unless do3=1 then use 3
;
trv=1           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: begin
    fnvar='mxd'
    iseas=18         ; use Apr-Sep
    end
  1: begin
    fnvar='trw'
    iseas=20         ; use Jun-Aug
    end
endcase
titadd=strupcase(fnvar)
;
; Now prepare for plotting
;
;
; Plots maps of correlations between MXD and Apr-Sep temperature and
; May-Aug precipitation.
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=18
endelse
def_1color,19,color='white'
def_1color,20,color='green'
def_1color,21,color='mlblue'
def_1color,22,color='lpurple'
def_1color,23,color='red'
def_1color,24,color='black'
def_1color,30,color='vlgrey'
cpl_usersym,/circle,/fill
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device) & coast.double=1 & coast.fill=1
coast.fillcolor=30
labels=def_labels(/off)
;
; Repeat for full, early and late periods
;
for iper = 0 , 0 do begin
  ;
  ; Restore all correlations
  ;
  case iper of
    0: restore,filename=fnvar+'_moncorr.idlsave'
    1: restore,filename=fnvar+'_moncorr_early.idlsave'
    2: restore,filename=fnvar+'_moncorr_late.idlsave'
  endcase
  ;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
  ;
  mtit='   (1881-1984)'
  ;
  ; Plot temperature correlations
  ;
  pause
  inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
    title='r( '+titadd+' , '+corrname(iseas)+' temperature )'+mtit
  ;
  oner=reform(allr(*,iseas,1))
  ;
  if !d.name eq 'PS' then device,font_size=11
  ;
if do3 eq 0 then begin
  wl=where(oner lt 0.,nwhite)
  if nwhite gt 0 then begin
    plots,statlon(wl),statlat(wl),psym=8,color=19
    cpl_usersym,/circle
    plots,statlon(wl),statlat(wl),psym=8
    cpl_usersym,/circle,/fill
  endif
  ;
  gl=where((oner ge 0.) and (oner lt 0.2),ngreen)
  if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=8,color=20
  ;
  bl=where((oner ge 0.2) and (oner lt 0.4),nblue)
  if nblue gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=21
  ;
  pl=where((oner ge 0.4) and (oner lt 0.5),npurple)
  if npurple gt 0 then plots,statlon(pl),statlat(pl),psym=8,color=22
  ;
  rl=where((oner ge 0.5) and (oner lt 0.6),nred)
  if nred gt 0 then plots,statlon(rl),statlat(rl),psym=8,color=23
  ;
  bl=where(oner ge 0.6,nblack)
  if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=24
  ;
  if !d.name eq 'PS' then device,font_size=14
;
legpos=convert_coord([-155.],[28.],/data,/to_normal)
  ;
if !d.name eq 'PS' then device,/courier,/bold
legend,$
  ['r <  +0.0           (N='+string(nwhite,format='(I3)')+')',$
   'r =  +0.0 to +0.2   (N='+string(ngreen,format='(I3)')+')',$
   'r =  +0.2 to +0.4   (N='+string(nblue,format='(I3)')+')',$
   'r =  +0.4 to +0.5   (N='+string(npurple,format='(I3)')+')',$
   'r =  +0.5 to +0.6   (N='+string(nred,format='(I3)')+')',$
   'r >  +0.6           (N='+string(nblack,format='(I3)')+')'],$
  psym=[15,10,10,10,10,10],color=[24,20,21,22,23,24],position=legpos,$
  charsize=0.85,spacing=1.25,margin=[0.45]
if !d.name eq 'PS' then device,/helvetica,/bold
;
endif else begin
  wl=where(oner lt 0.22,nwhite)
  if nwhite gt 0 then begin
    plots,statlon(wl),statlat(wl),psym=8,color=19
    cpl_usersym,/circle
    plots,statlon(wl),statlat(wl),psym=8
    cpl_usersym,/circle,/fill
  endif
  ;
  rl=where((oner ge 0.22) and (oner lt 0.6),nred)
  if nred gt 0 then plots,statlon(rl),statlat(rl),psym=8,color=23
  ;
  bl=where(oner ge 0.6,nblack)
  if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=24
  ;
  if !d.name eq 'PS' then device,font_size=16
  ;
  legpos=convert_coord([-150.],[30.],/data,/to_normal)
  ;
  if !d.name eq 'PS' then device,/courier,/bold
  legend,$
    ['r <  +0.22         (N='+string(nwhite,format='(I3)')+')',$
     'r =  +0.22 to +0.6 (N='+string(nred,format='(I3)')+')',$
     'r >  +0.6          (N='+string(nblack,format='(I3)')+')'],$
    psym=[15,10,10],color=[24,23,24],position=legpos,$
    charsize=0.85,spacing=1.35,margin=[0.65]
  if !d.name eq 'PS' then device,/helvetica,/bold
  ;
endelse
;
endfor
;
end
loadct,39
multi_plot,nrow=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=18
endelse
def_1color,19,color='white'
def_1color,20,color='green'
def_1color,21,color='deepblue'
def_1color,22,color='purple'
def_1color,23,color='red'
def_1color,24,color='black'
def_1color,30,color='lgrey'
cpl_usersym,/circle,/fill
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device) & coast.double=1 & coast.fill=1
coast.fillcolor=30
labels=def_labels(/off)
;
; Repeat for full, early and late periods
;
for iper = 0 , 0 do begin
  ;
  ; Restore all correlations
  ;
  case iper of
    0: restore,filename='mxd_moncorr.idlsave'
    1: restore,filename='mxd_moncorr_early.idlsave'
    2: restore,filename='mxd_moncorr_late.idlsave'
  endcase
  ;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
  ;
  mtit='   (1881-1984)'
  ;
  ; Plot temperature correlations
  ;
  pause
  inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
    title='r( MXD , April-September temperature )'+mtit
  ;
  oner=reform(allr(*,18,1))
  ;
  if !d.name eq 'PS' then device,font_size=11
  ;
  wl=where(oner lt 0.,nwhite)
  if nwhite gt 0 then begin
    plots,statlon(wl),statlat(wl),psym=8,color=19
    cpl_usersym,/circle
    plots,statlon(wl),statlat(wl),psym=8
    cpl_usersym,/circle,/fill
  endif
  ;
  gl=where((oner ge 0.) and (oner lt 0.2),ngreen)
  if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=8,color=20
  ;
  bl=where((oner ge 0.2) and (oner lt 0.4),nblue)
  if nblue gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=21
  ;
  pl=where((oner ge 0.4) and (oner lt 0.5),npurple)
  if npurple gt 0 then plots,statlon(pl),statlat(pl),psym=8,color=22
  ;
  rl=where((oner ge 0.5) and (oner lt 0.6),nred)
  if nred gt 0 then plots,statlon(rl),statlat(rl),psym=8,color=23
  ;
  bl=where(oner ge 0.6,nblack)
  if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=8,color=24
  ;
  if !d.name eq 'PS' then device,font_size=14
;
legpos=convert_coord([-155.],[28.],/data,/to_normal)
  ;
if !d.name eq 'PS' then device,/courier,/bold
legend,$
  ['r <  +0.0           (N='+string(nwhite,format='(I3)')+')',$
   'r =  +0.0 to +0.2   (N='+string(ngreen,format='(I3)')+')',$
   'r =  +0.2 to +0.4   (N='+string(nblue,format='(I3)')+')',$
   'r =  +0.4 to +0.5   (N='+string(npurple,format='(I3)')+')',$
   'r =  +0.5 to +0.6   (N='+string(nred,format='(I3)')+')',$
   'r >  +0.6           (N='+string(nblack,format='(I3)')+')'],$
  psym=[15,10,10,10,10,10],color=[24,20,21,22,23,24],position=legpos,$
  charsize=0.85,spacing=1.25,margin=[0.45]
if !d.name eq 'PS' then device,/helvetica,/bold
;
endfor
;
end
