;
; This reads in the calibrated quasi-NH Hugershoff series from the Holocene
; part 1 paper and lists the warmest and coolest 12 values, for plotting
; as maps in a separate programme.
;
restore,filename='regtemp_calibrated.nhversion.idlsave'
; Gets: regname,timey      & others!
;
kreg=where(regname eq 'NH')
kreg=kreg[0]
meanmxd=reform(calregts[*,kreg])
;
; Now let's list the warmest & coolest dozen
;
kl=where(finite(meanmxd),nk)
kmxd=meanmxd[kl]
ktim=timey[kl]
isort=sort(kmxd)
jsort=reverse(isort)
print,'Coldest and warmest values in the HUG quasi-NH'
print,'Year Temp(K)      Year Temp(K)    (anomalies wrt 1961-90 mean)'
for i = 0 , 11 do begin
  print,ktim[isort[i]],kmxd[isort[i]],ktim[jsort[i]],kmxd[jsort[i]],$
    format='(I4,F8.2,6X,I4,F8.2)'
endfor
;
end
