;
; Plots regional and large-scale averages of PARTIAL correlations between MXD &
; monthly & seasonal precip. and temperature.
;
docol=0         ; 0=B&W 1=color 2=symbols only
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: fnadd='mxd'
  1: fnadd='trw'
  2: fnadd='mxd-trw'
  3: fnadd='trwmxd'
endcase
titadd=strupcase(fnadd)
;
; Restore all regional correlations
;
restore,filename='reg'+fnadd+'_moncorr.idlsave'
;  allr,ncorr,nvar,nreg,regname,varname,corrname,allp,lowr,lowp,thalf
dotr=allr
dotp=allp
;
; Restore all local correlations
;
restore,filename=fnadd+'_moncorr.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
;
; Combine temp r with prec partial r
;
allp(*,*,1)=allp(*,*,0)
allp(*,*,0)=allr(*,*,1)
dotp(*,*,1)=dotp(*,*,0)
dotp(*,*,0)=dotr(*,*,1)
varname=reverse(varname)
conname=['',' constant Temp']
yname=['Correlation','Partial correlation']
;
if trv eq 3 then begin
  yname(0)=yname(1)
  titadd='TRW'
  conname=[' constant MXD',' constand MXD & Temp']
endif
;
; Restore regional breakdown
;
restore,filename='reg_mxdlists.idlsave'
;  ntree,treelist,nreg,regname
;
; For each region, average the site-by-site correlations together (and also
; find the range, by using the mean +- 2sd, unless < 10 sites in which case
; max and min are used)
; NOW SORTS THEM AND PICKS 5 and 95 %iles.
;
regr=fltarr(nreg,ncorr,nvar)
regmin=fltarr(nreg,ncorr,nvar)
regmax=fltarr(nreg,ncorr,nvar)
for i = 0 , nreg-1 do begin
  n=ntree(i)
  oner=allp(treelist(0:n-1,i),*,*)
  totr=total(oner,1)/float(n)
  regr(i,*,*)=totr(*,*)
  for j = 0 , ncorr-1 do begin
    for k = 0 , nvar-1 do begin
      rrr=reform(oner(*,j,k))
      kl=where(finite(rrr),nrrr)
      rrr=rrr(kl)
      s1=sort(rrr)
      regmin(i,j,k)=rrr(s1(fix(0.05*float(nrrr-1))))
      regmax(i,j,k)=rrr(s1(fix(0.95*float(nrrr-1))))
      regr(i,j,k)=rrr(s1(fix(0.50*float(nrrr-1))))
;      if nrrr lt 10 then begin
;        regmin(i,j,k)=min(rrr)
;        regmax(i,j,k)=max(rrr)
;      endif else begin
;        dummy=moment(rrr,sdev=sdev)
;        regmin(i,j,k)=(regr(i,j,k)-2.*sdev) > (-1.)
;        regmax(i,j,k)=(regr(i,j,k)+2.*sdev) < (1.)
;      endelse
    endfor
  endfor
endfor
;
; Now generate three extra composite regions
;
newr=fltarr(nreg+3,ncorr,nvar)
newmin=fltarr(nreg+3,ncorr,nvar)
newmax=fltarr(nreg+3,ncorr,nvar)
newp=fltarr(nreg+3,ncorr,nvar)
newr(0:nreg-1,*,*)=regr(*,*,*)
newmin(0:nreg-1,*,*)=regmin(*,*,*)
newmax(0:nreg-1,*,*)=regmax(*,*,*)
newp(0:nreg-1,*,*)=dotp(*,*,*)
regname=[regname,'HILAT','LOLAT','ALL']
;
rlist=[0,2,3,7,8]
newr(nreg,*,*)=total(regr(rlist,*,*),1)/float(n_elements(rlist))
newmin(nreg,*,*)=total(regmin(rlist,*,*),1)/float(n_elements(rlist))
newmax(nreg,*,*)=total(regmax(rlist,*,*),1)/float(n_elements(rlist))
newp(nreg,*,*)=total(dotp(rlist,*,*),1)/float(n_elements(rlist))
;
rlist=[1,4,5,6]
newr(nreg+1,*,*)=total(regr(rlist,*,*),1)/float(n_elements(rlist))
newmin(nreg+1,*,*)=total(regmin(rlist,*,*),1)/float(n_elements(rlist))
newmax(nreg+1,*,*)=total(regmax(rlist,*,*),1)/float(n_elements(rlist))
newp(nreg+1,*,*)=total(dotp(rlist,*,*),1)/float(n_elements(rlist))
;
newr(nreg+2,*,*)=total(regr,1)/float(nreg)
newmin(nreg+2,*,*)=total(regmin,1)/float(nreg)
newmax(nreg+2,*,*)=total(regmax,1)/float(nreg)
newp(nreg+2,*,*)=total(dotp,1)/float(nreg)
;
regr=newr
regmin=newmin
regmax=newmax
dotp=newp
nreg=nreg+3
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3,ncol=2,layout='caption'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
if docol eq 0 then begin
  def_1color,20,color='vlgrey'
  def_1color,21,color='mgrey'
endif else begin
  def_1color,20,color='lblue'
  def_1color,21,color='mred'
endelse
pp='('+[ ['a','c','e','g','i','k','m','o','q','s','u','w'] , $
         ['b','d','f','h','j','l','n','p','r','t','v','x'] ] + ') '
;
nvar=1
for i = nreg-1 , nreg-1 do begin
  for ivar = 0 , nvar-1 do begin
    pause
    x=findgen(28)
    yy=reform(regr(i,*,ivar))
    yydot=reform(dotp(i,*,ivar))
    yymin=reform(regmin(i,*,ivar))
    yymax=reform(regmax(i,*,ivar))
    y=fltarr(28)*!values.f_nan
    ymin=fltarr(28)*!values.f_nan
    ymax=fltarr(28)*!values.f_nan
    ydot=y
    yloc=[indgen(16)+1,indgen(5)*2+18]
    y(yloc)=yy(*)
    ymin(yloc)=yymin(*)
    ymax(yloc)=yymax(*)
    ydot(yloc)=yydot(*)
    plot,x,y,/nodata,$
      /ystyle,yrange=[-1.,1.],ytitle=yname(ivar),$
      xstyle=5,$
      title='r('+titadd+','+varname(ivar)+')'+conname(ivar)
    for j = -10,10,2 do oplot,!x.crange,replicate(float(j)*0.1,2),linestyle=1
    oplot,!x.crange,[0.,0.]
    oplot,[7.5,7.5],!y.crange,thick=4
    if docol lt 2 then begin
      cpl_barts,x,y,outline=-1,/overplot,bar_color=[21,20],thick=2
    endif
    if !d.name eq 'PS' then device,font_size=8
    for j = 0 , ncorr-1 do begin
      x1=x(yloc(j))
      y1min=ymin(yloc(j))
      y1max=ymax(yloc(j))
      plots,x1,y1min,psym=def_sym(12)
      plots,x1,y1max,psym=def_sym(11)
      y1=ydot(yloc(j))
      plots,x1,y1,psym=def_sym(15),thick=3
      if docol eq 2 then begin
        oplot,[x1,x1],[y1min,y1max]
        y1=y(yloc(j))
        oplot,x1+[-0.5,0.5],[y1,y1],thick=3
      endif
      x1=x(yloc(j))+0.28
      y1=!y.crange(0)-0.05
      xyouts,x1,y1,corrname(j),align=1,orient=90.
    endfor
    xyouts,7.,-0.85,align=1.,'Previous!Cyear'
    xyouts,8.,-0.85,align=0.,'Same!Cyear'
    if !d.name eq 'PS' then device,font_size=14
  endfor
endfor
;
end
