;
; Plots maps of correlations between MXD and Apr-Sep temperature and
; May-Aug precipitation.
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=11
endelse
def_1color,19,color='white'
def_1color,20,color='green'
def_1color,21,color='deepblue'
def_1color,22,color='purple'
def_1color,23,color='red'
def_1color,24,color='black'
def_1color,30,color='mgrey'
cpl_usersym,/circle,/fill
;
map=def_map(/npolar)  &  map.limit(0)=25.
map.xmargin=[0,0] & map.ymargin=[0,0]
coast=def_coast(/get_device) & coast.double=0
labels=def_labels(/off)
;
;trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
for trv = 0 , 0 do begin
case trv of
  0: begin
    fnadd='mxd'
    iseas=18
    end
  1: begin
    fnadd='trw'
    iseas=20
    end
endcase
titadd=strupcase(fnadd)
;
; Repeat for full, early and late periods
;
for iper = 0 , 0 do begin
  ;
  ; Restore all correlations
  ;
  case iper of
    0: restore,filename='datastore/'+fnadd+'_moncorr.idlsave'
    1: restore,filename='datastore/'+fnadd+'_moncorr_early.idlsave'
    2: restore,filename='datastore/'+fnadd+'_moncorr_late.idlsave'
  endcase
  ;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
  ;
  mtit='   (1881-1984)'
  ;
  ; Plot temperature correlations
  ;
  inter_boxfd,/nodata,map=map,coast=coast,labels=labels
;    title='r( MXD , April-September temp.)'+mtit
  ;
  oner=reform(allr(*,iseas,1))
  ;
  if !d.name eq 'PS' then device,font_size=10
  ;
  cpl_usersym,/circle,/fill
  plots,statlon,statlat,psym=8,color=19
  ;
  wl=where(oner lt 0.22,nwhite)
  if nwhite gt 0 then plots,statlon(wl),statlat(wl),psym=def_sym(15)
  ;
  gl=where((oner ge 0.22) and (oner lt 0.4),ngreen)
  if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=def_sym(1)
  ;
  pl=where((oner ge 0.4) and (oner lt 0.5),npurple)
  if npurple gt 0 then plots,statlon(pl),statlat(pl),psym=def_sym(2)
  ;
  rl=where((oner ge 0.5) and (oner lt 0.6),nred)
  if nred gt 0 then plots,statlon(rl),statlat(rl),psym=def_sym(16)
  ;
  bl=where(oner ge 0.6,nblack)
  if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=def_sym(10)
  ;
  if !d.name eq 'PS' then device,font_size=11
;
; Overlay regions
;
; Straight lines first
map_plots,[-15.,-15.],[90.,35.],thick=3
map_plots,[61.,61.],[90.,60.],thick=3
map_plots,[128.,128.],[90.,60.],thick=3
map_plots,[-170.,-170.],[90.,50.],thick=3
map_plots,[-125.,-125.],[90.,60.],thick=3
map_plots,[-45.,-45.],[90.,40.],thick=3
map_plots,[30.,30.],[60.,35.],thick=3
map_plots,[115.,115.],[60.,25.],thick=3
map_plots,[60.,60.],[40.,25.],thick=3
map_plots,[-135.,-135.],[50.,30.],thick=3
map_plots,[-100.,-100.],[50.,30.],thick=3
map_plots,[-105.,-105.],[55.,50.],thick=3
map_plots,[-120.,-120.],[60.,55.],thick=3
;
; Now curved lines of constant latitude
y1=[60.,50.,30.,60.,55.,40.,53.,35.,60.,40.,25.]
x1=[-180.,-170.,-135.,-125.,-120.,-100.,-15.,-15.,30.,30.,60.]
x2=[-170.,-100.,-100.,-120.,-105.,-45.,30.,30.,180.,115.,115.]
for i = 0 , n_elements(y1)-1 do begin
  n=x2(i)-x1(i)+1
  xval=findgen(n)+x1(i)
  yval=replicate(y1(i),n)
  map_plots,xval,yval,thick=3
endfor
;
; Now plot region names
regname=['NEUR','SEUR','NSIB','ESIB','CAS','TIBP',$
  'WNA','NWNA','ECCA']
reglat=[  70,  35,  85,  81,  58,  37,  32,  67,  62]
reglon=[ -10, -25,  86,-176,  38,  70,-122,-129, -72]
for i = 0 , n_elements(regname)-1 do $
  xyouts,reglon(i),reglat(i),regname(i),charsize=0.7
;
legpos=convert_coord([-146.],[25.],/data,/to_normal)
  ;
if !d.name eq 'PS' then device,/courier,/bold,font_size=10
for ileg = 0 , 1 do begin
legend,$
  ['r('+titadd+','+corrname(iseas)+' temp.) 1881-1984',$
   'r <  +0.22         (N='+string(nwhite,format='(I3)')+')',$
   'r =  +0.22 to +0.4 (N='+string(ngreen,format='(I3)')+')',$
   'r =  +0.4  to +0.5 (N='+string(npurple,format='(I3)')+')',$
   'r =  +0.5  to +0.6 (N='+string(nred,format='(I3)')+')',$
   'r >  +0.6          (N='+string(nblack,format='(I3)')+')'],$
  linestyle=[-1,0,0,0,0,0],psym=[-1,15,1,2,16,10],position=legpos,$
  charsize=0.85,spacing=1.25,margin=[0.45],corners=legc
  if ileg eq 0 then begin
    polyfill,color=!p.background,/normal,legc[[0,2,2,0,0]],legc[[1,1,3,3,1]]
  endif
endfor
if !d.name eq 'PS' then device,/helvetica,/bold,font_size=11
;
endfor
;
endfor
;
; Write chronology locations to a file
;
openw,1,'briffa_osborn_fig1.dat'
printf,1,'Location of the chronologies plotted in Figure 1 of:
printf,1
printf,1,'Briffa KR, Osborn TJ and Schweingruber FH (2004)'
printf,1,'Large-scale temperature inferences from tree rings: a review.'
printf,1,'Global and Planetary Change 40, 11-26.
printf,1
printf,1,'Number of chronologies ',txt(nchron)
printf,1
printf,1,'If more than one chronology has been developed at a single site,'
printf,1,'usually from a different tree species, then these are listed
printf,1,'separately.  So multiple entries with identical locations are'
printf,1,'possible.'
printf,1
printf,1,'  Latitude Longitude (positive for N or E, negative for S or W)'
for i = 0 , nchron-1 do printf,1,statlat[i],statlon[i],format='(2F10.3)'
close,1
;
end
