;
; Shows the hugershoff 'ALL' recon & errors, blown up for recent period
; and decadally smoothed back to 1400 AD.
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=5,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,bold=0,font_size=14
endelse
def_1color,20,color='mdgrey'
def_1color,21,color='palegrey'
def_1color,22,color='red'
def_1color,22,color='black'
!x.omargin=[5,5]
bittit='('+['b','c','d','e']+')'
;
for jjj = 0 , 1 do begin
;for jjj = 0 , 3 do begin
  case jjj of
    0: begin
      dosmooth=0
      thalf=10
      end
    1: begin
      dosmooth=1
      thalf=10
      end
    2: begin
      dosmooth=1
      thalf=25
      end
    3: begin
      dosmooth=1
      thalf=50
      end
   endcase
;
wantreg='ALL'       ; 'ALL' or 'NH'
;dosmooth=1          ; 0=errors for interannual data 1=for smoothed data
;thalf=25.
;
fnhead='regtemp'          ;+regname
;fnhead='bandtemp'          ;+regname
if dosmooth eq 1 then smst='sm'+string(thalf,format='(I2.2)') else smst=''
fntail1='_calibrated.'+strlowcase(wantreg)+'version.idlsave'
fntail2=smst+'_mxd_errors.idlsave'
;
fn='datastore/'+fnhead+fntail2
print,fn
restore,filename=fn
erryr=timey
if regname(9) ne wantreg then message,'Need it calibrated for '+wantreg
;
fn=fnhead+fntail1
print,fn
restore,filename=fn
if n_elements(erryr) ne n_elements(timey) then message,'Oooops!'
if regname(9) ne wantreg then message,'Need it calibrated for '+wantreg
;
agets=calregts(*,9)
serr=calregse(*,9)
temts=tempregts(*,9)
tempyr=temptimey
;
if jjj eq 0 then begin
  plot,[0,1],/nodata,$
    /xstyle,xrange=[1871,1994],xtitle='Year',$
    /ystyle,yrange=[-1.5,1.0],ytitle='Temperature (!Uo!NC wrt 1961-90)',$
    ymargin=[4,0]
;    title=regname+'  '+smst
  ;
  xfill=[timey,reverse(timey)]
  yfill=[agets-serr*2.,reverse(agets+serr*2.)]
  kl=where(finite(yfill),nkeep)
  yfill=yfill(kl)
  xfill=xfill(kl)
;  polyfill,xfill,yfill,color=20,noclip=0
  ;
  xfill=[timey,reverse(timey)]
  yfill=[agets-serr,reverse(agets+serr)]
  kl=where(finite(yfill),nkeep)
  yfill=yfill(kl)
  xfill=xfill(kl)
;  polyfill,xfill,yfill,color=21,noclip=0
  ;
  oplot,!x.crange,[0.,0.],linestyle=1
  oplot,tempyr,temts,thick=2,color=22
  oplot,timey,agets,thick=5
  xyouts,1874,-1.4,'(a)'
endif
;
if dosmooth eq 0 then yr=[-2.2,1.0] else yr=[-1.2,0.7]
plot,[0,1],/nodata,$
  /xstyle,xrange=[1400,1994],$         ;xtitle='Year',$
  /ystyle,yrange=yr,ytitle='Temperature (!Uo!NC wrt 1961-90)',$
  ymargin=[2,0]
;  title=regname+'  '+smst
;
filter_cru,thalf,/nan,tsin=temts,tslow=temlow
filter_cru,thalf,/nan,tsin=agets,tslow=agelow
if dosmooth eq 1 then begin
  agets=agelow
  temts=temlow
endif
;
xfill=[timey,reverse(timey)]
yfill=[agets-serr*2.,reverse(agets+serr*2.)]
kl=where(finite(yfill),nkeep)
yfill=yfill(kl)
xfill=xfill(kl)
polyfill,xfill,yfill,color=20,noclip=1
;
xfill=[timey,reverse(timey)]
yfill=[agets-serr,reverse(agets+serr)]
kl=where(finite(yfill),nkeep)
yfill=yfill(kl)
xfill=xfill(kl)
polyfill,xfill,yfill,color=21,noclip=1
;
oplot,!x.crange,[0.,0.],linestyle=1
;
if dosmooth ne 0 then oplot,tempyr,temts,thick=1+dosmooth
oplot,timey,agets,thick=2+3.*dosmooth
xyouts,1420,yr[0]+0.1,bittit(jjj)
;
endfor
;
end
