;
; Makes plots of tree site locations for my webpage.
; Use ps2gif <fn> 0.5 for big figures
; Use ps2gif <fn> 0.1 for thumbnails
;
iver=0   ; 0=387(ALL), 1=341(MXD>0.22), 2=127(TRW>0.22)
;
; Get site locations
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
;
case iver of
 0: begin
  fnadd=''
 end
 1: begin
  fnadd='mxd'
  iseas=18  ; Apr-Sep r
 end
 2: begin
  fnadd='trw'
  iseas=20  ; Jun-Aug r
 end
endcase
;
; Get correlations against temperature, to use for selecting chronologies
;
if strlen(fnadd) gt 1 then begin
 ;
 ; Extend !path to include Craig M's extended save file routines
 !path=!path+':/cru/u2/f055/idllib_3rd/craigm/'
 ;
 fnsav='datastore/'+fnadd+'_moncorr.idlsave'
 print,fnsav
 cmrestore,fnsav,$
  allr,altlat,altlon,names=['allr','statlat','statlon']
 if array_equal(altlat,statlat) eq 0 then message,'Failed to match!'
 if array_equal(altlon,statlon) eq 0 then message,'Failed to match!'
 ;
endif
;
ploton,1
;
; Get rid of control codes from location names!
;
location=string( ( byte(location) < 126B ) > 32B )
;
loadct,39
multi_plot,nrow=2,ncol=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  fac=1.
endif else begin
  fac=2.
endelse
def_1color,10,color='vvlgreen'
;
map=def_map(/npolar)  &  map.limit(0)=25.
labels=def_labels(/off)  &  labels.gridon=0  &  labels.dlon=30.
labels.dlat=10.
coast=def_coast(/get_device)
coast.double=0
coast.fill=1
coast.fillcolor=10
coast.thick=[0.5,0.5]
;
inter_boxfd,/nodata,map=map,$
  labels=labels,coast=coast
;
!p.ticklen=0.03
lon_polar,map=map,[-180,-150.,-120.,-90.,-60.,-30.,30.,60.,120.,150.],/dotick
;
; Overlay regions
;
map_plots,[-15.,-15.],[90.,35.],thick=3
map_plots,[61.,61.],[90.,60.],thick=3
map_plots,[128.,128.],[90.,60.],thick=3
map_plots,[-170.,-170.],[90.,50.],thick=3
map_plots,[-125.,-125.],[90.,60.],thick=3
map_plots,[-45.,-45.],[90.,40.],thick=3
map_plots,[30.,30.],[60.,35.],thick=3
map_plots,[115.,115.],[60.,25.],thick=3
map_plots,[60.,60.],[40.,25.],thick=3
map_plots,[-135.,-135.],[50.,30.],thick=3
map_plots,[-100.,-100.],[50.,30.],thick=3
map_plots,[-105.,-105.],[55.,50.],thick=3
map_plots,[-120.,-120.],[60.,55.],thick=3
;
y1=[60.,50.,30.,60.,55.,40.,53.,35.,60.,40.,25.]
x1=[-180.,-170.,-135.,-125.,-120.,-100.,-15.,-15.,30.,30.,60.]
x2=[-170.,-100.,-100.,-120.,-105.,-45.,30.,30.,180.,115.,115.]
for i = 0 , n_elements(y1)-1 do begin
  n=x2(i)-x1(i)+1
  xval=findgen(n)+x1(i)
  yval=replicate(y1(i),n)
  map_plots,xval,yval,thick=3
endfor
;
regname=['NEUR','SEUR','NSIB','ESIB','CAS','TIBP',$
  'WNA','NWNA','ECCA']
reglat=[  73,  35,  85,  81,  53,  37,  30,  67,  62]
reglon=[ -10, -19,  86,-176,  38,  70,-135,-129, -72]
for i = 0 , n_elements(regname)-1 do $
  xyouts,reglon(i),reglat(i),regname(i),charsize=0.7
;
xcir=findgen(361)-180.
ycir=replicate(map.limit[0],361)
map_plots,xcir,ycir
;
; Output table of sites used
;
if iver eq 0 then begin
 ns=nchron
 sl=indgen(ns)
endif else begin
 oner=reform(allr[*,iseas,1])   ; get r(tree,temp)
 sl=where(oner ge 0.22,ns)
endelse
nst=txt(ns)
;
openw,1,'b02sens'+nst+'_site.txt'
printf,1,'Table of tree-ring sites used in'
printf,1
printf,1,'Briffa KR et al. (2002) Tree-ring width and density data around the Northern Hemisphere: part 1, local and regional climate signals. The Holocene 12, 737-757.'
printf,1
printf,1,'Number of sites: '+nst
printf,1
printf,1,'    ID                      Name     Abbr Genus Longitude  Latitude Start   End'
for is = 0 , ns-1 do printf,1,strtrim(idno[sl[is]],2),strtrim(location[sl[is]],2),$
 strtrim(idname[sl[is]],2),strtrim(tree[sl[is]],2),statlon[sl[is]],statlat[sl[is]],$
 yrstart[sl[is]],yrend[sl[is]],$
 format='(A6,A26,A9,A6,2F10.2,2I6)'
close,1
;
x=statlon[sl]
y=statlat[sl]
cpl_usersym,/circle,/fill
plots,x,y,psym=8,color=!p.background,symsize=1.05,noclip=0
cpl_usersym,/circle
plots,x,y,psym=8,thick=1,symsize=1.05,noclip=0
print,'Number of sites:',n_elements(x)
;
plotoff
;
spawn,'cp idl.ps1 b02sens'+nst+'_map.ps'
spawn,'mv idl.ps1 b02sens'+nst+'_map_thumb.ps'
spawn,'ps2gif b02sens'+nst+'_map 0.5'
spawn,'ps2gif b02sens'+nst+'_map_thumb 0.1'
;
end
