;
restore,filename='reglists.idlsave'
;
; Do a ranking of the adusted MXD timeseries for each region (takes first
; differences of the timeseries before ranking them!).  Also, plots this
; first difference timeseries for ALL only.
;
plot,[0,1]
multi_plot,nrow=4,layout='large'
if !d.name eq 'X' then begin
  window,ysize=900
  initx
endif
;
for i = 0 , nreg-1 do begin
  openw,1,'ext_dens1st_'+regname(i)+'.out'
  restore,filename='densadj_'+regname(i)+'.idlsave'
  yall=densadj
  ymin=shift(yall,1)
  ymin(0)=!values.f_nan
  densadj=yall-ymin
;
if i eq 0 then begin
  filter_cru,20,tsin=densadj,tslow=tslow,/nan 
  cpl_barts,x,densadj,title='First difference of MXD anomaly'+$ 
    ' for region: '+regname(i),xtitle='Year',/xstyle,$ 
    zeroline=tslow,yrange=[-8,4]
  oplot,x,tslow,thick=2 
  oplot,!x.crange,[0.,0.]
  oplot,!x.crange,[-2.,-2.],linestyle=1
endif
;
  keeplist=where(finite(densadj),nkeep)
  y=densadj(keeplist)
  x=x(keeplist)
  slist=sort(y)
  printf,1,'Extremes of first difference of normalised MXD anomalies for region: '+$
      regname(i)
  printf,1,' Low extremes                     | High extremes'
  printf,1,' Rank Year   Density              | Rank Year   Density          '
  for j = 0 , 59 do begin
    k=nkeep-j-1
    printf,1,j+1,x(slist(j)),y(slist(j)),$
          k+1,x(slist(k)),y(slist(k)),$
          format='(2I5,F10.4,9X,6X,2I5,F10.4,10X)'
  endfor
  close,1
endfor
;
end
