;
; Computes correlations on full, high and low pass timeseries of density
; anomalies between the regions
;
restore,filename='reglists.idlsave'
;
; Read in timeseries pairs and compute correlations
;
openw,1,'corr_dens2dens.out'
thalf=20.
printf,1,'Correlations between regional maximum density timeseries'
printf,1,'   Region 1     Region 2    Full  High   Low'
;
for i = 0 , nreg-2 do begin
  for j = i+1 , nreg-1 do begin
    print,i,j
    ;
    restore,filename='densts_'+regname(i)+'.idlsave'
    y1=wdens
    filter_cru,thalf,tsin=y1,tslow=ylow1,tshigh=yhi1,/nan
    ;
    restore,filename='densts_'+regname(j)+'.idlsave'
    y2=wdens
    filter_cru,thalf,tsin=y2,tslow=ylow2,tshigh=yhi2,/nan
    ;
    keeplist=where(finite(y1+y2),nkeep)
    ts1=y1(keeplist)
    ts2=y2(keeplist)
    r1=correlate(ts1,ts2)
    ;
    ts1=yhi1(keeplist)
    ts2=yhi2(keeplist)
    r2=correlate(ts1,ts2)
    ;
    ts1=ylow1(keeplist)
    ts2=ylow2(keeplist)
    r3=correlate(ts1,ts2)
    ;
    printf,1,regname(i),regname(j),r1,r2,r3,$
      format='(A11,2X,A11,2X,3F6.2)'
    ;
  endfor
endfor
close,1
;
end
