;
; Computes lists of tree numbers in each region
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_varget,ncid,'longitude',xlon
ncdf_varget,ncid,'latitude',ylat
ncdf_close,ncid
;
; Remove Nepal from them all too, individually **********************
;
;keeplist=where(ylat ge 30.,maxtrees)
;xlon=xlon(keeplist)
;ylat=ylat(keeplist)
;
; Define arrays
;
maxtrees=n_elements(xlon)
regname=['ALL','NORTH_OF_60','SOUTH_OF_60','WNA','ENA','CER','NEUR','SEUR',$
  'ARCTIC','EXTRA-ARCTIC']
nreg=n_elements(regname)
ntree=intarr(nreg)
treelist=fltarr(maxtrees,nreg)  &  treelist(*,*)=!values.f_nan
;
; 1) All  (except Nepal)
;
i=0
keeplist=where(ylat ge 30.,nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 2) North of 60
;
i=1
keeplist=where(ylat ge 60.,nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 3) South of 60
;
i=2
keeplist=where( (ylat lt 60.) and (ylat ge 30.),nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 4) WNA
;
i=3
keeplist=where( ( (xlon lt -105.) and (ylat lt 55.) ) $
             or ( (xlon lt -107.) and (ylat ge 55.) ) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 5) ENA
;
i=4
keeplist=where( ( (xlon lt -40.) and (xlon ge -105.) and (ylat lt 55.) ) $
             or ( (xlon lt -40.) and (xlon ge -107.) and (ylat ge 55.) ) $
             , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 6) CER
;
i=5
keeplist=where( (xlon ge 60.) and (ylat ge 30.),nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 7) NEUR
;
i=6
keeplist=where( (xlon ge -15.) and (xlon lt 60.) and (ylat ge 54.8) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 8) SEUR
;
i=7
keeplist=where( (xlon ge -15.) and (xlon lt 35.) and (ylat lt 54.8) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 9) ARCTIC
;
i=8
keeplist=where(ylat ge 66.6,nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
; 10) OUTSIDE THE ARCTIC
;
i=9
keeplist=where(ylat lt 66.6,nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
;
save,filename='reglists.idlsave',ntree,treelist,nreg,regname
;
end
