;
; Checks that the additional MXD chronologies (Tornetrask and Jasper)
; are correct
;
loadct,39
multi_plot,nrow=4,layout='large'
if !d.name eq 'X' then begin
  window,ysize=900
endif
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_diminq,ncid,'time',dummy,ntime
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'year',x
ncdf_varget,ncid,'statloc',location
location=string(location)
ncdf_varget,ncid,'longitude',statlon
ncdf_varget,ncid,'latitude',statlat
ncdf_varget,ncid,'density',density
ncdf_attget,ncid,'density','missing_value',valmiss
ncdf_varget,ncid,'fraction',weight
ncdf_close,ncid
;
misslist=where(density eq valmiss,nmiss)
density(misslist)=!values.f_nan
;
  ; Now plot them
  ;
ele=where(location eq 'Tornetrask')
wdens=reform(density(*,ele))
filter_cru,10,tsin=wdens,tslow=tslow,/nan 
cpl_barts,x,wdens,title='Tornetrask MXD'+string(statlat(ele),statlon(ele),$ 
    format='(2F8.2)'),$
  xtitle='Year',/xstyle,$ 
  zeroline=tslow,yrange=[-5.7,3.7],/ystyle
oplot,x,tslow,thick=3 
;
ele=where(location eq 'Jasper')
wdens=reform(density(*,ele))
filter_cru,20,tsin=wdens,tslow=tslow,/nan 
cpl_barts,x,wdens,title='Jasper MXD'+string(statlat(ele),statlon(ele),$ 
    format='(2F8.2)'),$
  xtitle='Year',/xstyle,$ 
  zeroline=tslow,yrange=[-5.7,3.7],/ystyle
oplot,x,tslow,thick=2 
;
end
