;
; Creates MEAN timeseries from adjusted regional timeseries and adjusts the
; MEAN for changing sample size using a time-dependent rbar.
; Timeseries are weighted by their EPS when computing the mean.
;
ploton,1
multi_plot,nrow=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=900
  !p.font=-1
  initx
endif else begin
  !p.font=0
  device,/helvetica,bold=0,font_size=12,xsize=17.9
endelse
def_1color,20,color='dgreen'
def_1color,21,color='black'
def_1color,22,color='purple'
def_1color,23,color='red'
def_1color,24,color='deepblue'
;
; Get adjusted regional timeseries
;
restore,filename='reglists.idlsave'
nreg=nreg-2          ; not ARCTIC or EXTRA-ARCTIC
;
for i = 3 , nreg-1 do begin       ; not 0, 1 & 2 (ALL, NORTH & SOUTH)
  ;
  ; Get adjusted regional timseries
  ;
  restore,filename='densadj_'+regname(i)+'.idlsave'
  ;
  if i eq 3 then begin
    nyr=n_elements(x)
    ndata=nreg-3           ; not 0, 1 & 2
    allmxd=fltarr(nyr,ndata)
    alleps=fltarr(nyr,ndata)
  endif
  allmxd(*,i-3)=densadj(*)
  alleps(*,i-3)=denseps(*)
  ;
endfor
;
; Get grand correlation matrix between regions
;
restore,filename='rbartd_dens_MEAN.idlsave'
;
; Make a time-dependent rbar next
;
print,'Time-dependent rbar for ',nyr,'  years'
rbar_td=fltarr(nyr)*!values.f_nan
for it = 0 , nyr-1 do begin
  print,it,format='($,I4)'
  mask = where( finite(allmxd(it,*)) , nsamp)
  if nsamp gt 0 then begin
    if nsamp eq 1 then begin
      rbar_td(it)=1.               ; if n=1 then n'=1 regardless of rbar
    endif else begin
      ; get reduced grandr
      redr=grandr(mask,*)
      redr=redr(*,mask)
      ; Total it and average it, but only do i<>j.
      totr=0.
      totn=0.
      for j = 1 , nsamp-1 do begin
        for k = 0 , j-1 do begin
          totr=totr+redr(j,k)        ; should have no missing values I hope
          totn=totn+1.
          if redr(j,k) eq 1. then message,'Ooops!'
        endfor
      endfor
      rbar_td(it)=totr/totn
    endelse
  endif
endfor
print
;
; Now compute a weighted mean of the available regional timeseries
;
n=float(total(finite(allmxd),2))   ; compute timeseries of number of regions
totmxd=total(allmxd*alleps,2,/nan)
toteps=total(alleps,2,/nan)
meanmxd=totmxd/toteps
;
; Now need to adjust for varying sample size
;
xadj=mkeffective(meanmxd,n,rbar=rbar_td,neff=neff)
meanmxd=xadj
;
; Now normalise w.r.t. 1881-1960
;
mknormal,meanmxd,x,refperiod=[1881,1960]
;
; Now plot them
;
filter_cru,40,tsin=meanmxd,tslow=tslow,/nan 
cpl_barts,x,meanmxd,$
  bar_color=[23,24],$
  ;title='Normalised adjusted MEAN of all regional MXD timeseries',$ 
  xtitle='Year',/xstyle,$ 
  ytitle='        Normalised mean density anomaly  (standard deviation units)',$
  yminor=4,yticks=4,ytickv=findgen(5)*2.-6.,$
  zeroline=tslow,yrange=[-9,3],ystyle=9
oplot,x,tslow,thick=4 
oplot,!x.crange,[0.,0.]
;oplot,!x.crange,[-2.,-2.],linestyle=1
;
axis,xaxis=1,/xstyle           ;,xtitle='Year'
axis,xaxis=0,/xstyle,xtickformat='nolabels'
;
xyouts,1450.,-6.,/data,'Major volcanoes:',charsize=0.85,color=22
xyouts,1608.,-3.1,/data,'LFD',charsize=0.85,color=20
xyouts,1415.,1.9,/data,'Tree-ring density / Northern Boreal Forest',$
  charsize=0.85
xyouts,1975.,0.9,/data,'T',charsize=0.85,color=21
;
yrlab=['1448','1453','1495','1544','1587','1601','1641/2/3','1666',$
  '1675','1695','1698/9','1740','1783','1816/7/8','1836/7','1884','1912']
yry  =[-3.3  ,-4.85 ,-3.03 ,-3.10 ,-3.32 ,-6.0  ,-5.       ,-3.42 ,$
  -3.81 ,-4.15 ,-3.52   ,-3.35 ,-3.05 ,-5.03     ,-3.5    ,-3.6  ,-4.1]
yrx  =[1440.5,1455  ,1495  ,1544  ,1587  ,1589  ,1642      ,1658  ,$
  1675  ,1695  ,1711    ,1740  ,1783  ,1817      ,1837    ,1884  ,1912]
nlab=n_elements(yrlab)
for i = 0 , nlab-1 do xyouts,yrx(i),yry(i),/data,yrlab(i),size=0.6,align=0.5
;
keeppc=!p.color
!p.color=22
yrvei=[1450,1452,1471,1477,1480,1482,1580,1586,1593,1600,1640,1641,1660,$
  1663,1667,1673,1680,1707,1739,1800,1815,1835,1853,1854,1883,1886,1902,$
  1907,1912,1932,1956,1980,1982,1991]
yrsiz=[5,6,5,5,5,5,6,5,5,6,5,6,6,5,5,5,5,5,5,5,7,5,5,5,6,5,6,5,6,5,5,5,5,6]
nvei=n_elements(yrvei)
ym=!y.crange(0)
for i = 0 , nvei-1 do begin
  z=yrvei(i)
  y=yrsiz(i)
  case y of
    5: plots,[z,z,z-1,z,z+1,z],[ym,ym+0.4,ym+0.4,ym+0.7,ym+0.4,ym+0.4]
    6: begin
      plots,[z,z],[ym,ym+1.1],thick=3
      polyfill,[z-2.,z,z+2.,z-2.],[ym+1.1,ym+1.6,ym+1.1,ym+1.1]
      end
    7: begin
      plots,[z,z],[ym,ym+2.2],thick=5
      polyfill,[z-3.,z,z+3.,z-3.],[ym+2.2,ym+2.7,ym+2.2,ym+2.2]
      end
  endcase
endfor
;
xyouts,1449.,ym+0.3,align=1.,'?',size=0.6
xyouts,1579.,ym+0.3,align=1.,'?',size=0.6
xyouts,1659.,ym+0.3,align=1.,'?',size=0.6
;
xyouts,1420.,ym+0.3,orient=90.,'VEI',size=0.9
plots,[1432.,1432.],[ym,ym+2.7],thick=3
plots,[1432.,1438.],[ym+2.7,ym+2.7],thick=3
plots,[1432.,!x.crange(1)],[ym+2.7,ym+2.7],linestyle=1
plots,[1432.,1438.],[ym+1.6,ym+1.6],thick=3
plots,[1432.,!x.crange(1)],[ym+1.6,ym+1.6],linestyle=1
plots,[1432.,1438.],[ym+0.7,ym+0.7],thick=3
plots,[1432.,!x.crange(1)],[ym+0.7,ym+0.7],linestyle=1
xyouts,1431.,ym+2.5,'7',size=0.6,align=1.
xyouts,1431.,ym+1.4,'6',size=0.6,align=1.
xyouts,1431.,ym+0.5,'5',size=0.6,align=1.
!p.color=keeppc
;
axis,yaxis=1,ystyle=1,yrange=!y.crange*0.116626,$         ;-0.105023,$
  yminor=4,yticks=5,ytickv=findgen(6)*0.2-0.8,$
  ytitle='        Estimated Northern Hemisphere temperature anomaly  (!Uo!NC)'
;
;plot,x,n,ytitle='Sample size',/xstyle
;
;plot,x,rbar_td,/xstyle,ytitle='rbar'
;
;plot,x,neff,/xstyle,ytitle='Effective sample size'
;
; Now save the weighted mean timeseries, for further analysis
;
densadj=meanmxd
save,filename='densadj_MEAN.idlsave',x,densadj,n,neff
;
; Also plot the comparison between the Hugerhoff and Age-Banded curves at the
; low frequencies
;
; OLD INCORRECT SCIENCE ONE
restore,filename='../treeharry/briffa_fellow.idlsave'
;  tshug,yrhug,tsage,yrage
;oplot,yrage,tsage,color=20,thick=5
;
; NEW AGE-BANDED! BASED ON MULTI-PCR CALIBRATION
;
restore,filename='../tree6/bandtempNH_calmultipcr.idlsave'
; Gets: prednh,yrmxd etc.
mknormal,prednh,yrmxd,refperiod=[1881,1960]
filter_cru,40.,/nan,tsin=prednh,tslow=agelow
oplot,yrmxd,agelow,color=20,thick=5
;
; Now overlay instrumental curve to show the decline
;
restore,filename='../tree3/briffa_fellow.idlsave'
; x,instrlo
;
kl=where(x ge 1881)
;oplot,x(kl),instrlow(kl),thick=4,linestyle=1
oplot,x(kl),instrlow(kl),thick=8,color=21
;oplot,x(kl),instrlow(kl),thick=4,color=!p.background
;oplot,x(kl),instrlow(kl),thick=1
;
plotoff,/gv
;
end
