function tim_hist,y,binsize=binsize,binvals=binvals
;
; Wrapper for histogram, which returns the values of all bins, and ignores
; missing data as specified by NaN.
;
keeplist=where(finite(y),nkeep)          ; remove missing values
if nkeep eq 0 then begin
  return,[0]
endif else begin
  ykeep=y(keeplist)
  omin=min(ykeep)                        ; find data range
  omax=max(ykeep)
  xmin=fix(omin/binsize-0.999*(omin lt 0.))*binsize    ; compute min and max
  xmax=fix(omax/binsize+0.999*(omax gt 0.))*binsize    ; bin interfaces
  accur=binsize*0.01        ; ensure that the maximum value is not marginally
  xmax2=xmax+accur           ; less than an interval
  errhist=histogram(ykeep,binsize=binsize,min=xmin,max=xmax2)
  nbin=n_elements(errhist)
  binvals=findgen(nbin)*binsize+xmin
print,omin,omax
print,xmin,xmax
print,binvals
print,binvals(nbin-1)-xmax
  if abs(binvals(nbin-1)-xmax) gt accur then $
    message,'Not got the bin values right yet'
  if total(errhist) ne nkeep then message,'Some values not in range'
  return,errhist/float(nkeep)
endelse
;
end
