;
; Computes lists of tree numbers in each region
;
ncid=ncdf_open('tree_dens_su1400.nc')
ncdf_varget,ncid,'longitude',xlon
ncdf_varget,ncid,'latitude',ylat
ncdf_close,ncid
;
; Define arrays
;
maxtrees=n_elements(xlon)
nreg=14
lonleft=findgen(nreg)*10.+30.
regname=string(lonleft,format='(I3)')+'-'+string(lonleft+10,format='(I3)')+'E'
print,regname
ntree=intarr(nreg)
treelist=fltarr(maxtrees,nreg)  &  treelist(*,*)=!values.f_nan
;
for i = 0 , nreg-1 do begin
  ;
  keeplist=where( (ylat ge 60.) and (ylat le 75.) and $
                  (xlon ge lonleft(i)) and (xlon lt lonleft(i)+10.) ,nkeep)
  ntree(i)=nkeep
  treelist(0:nkeep-1,i)=keeplist(*)
  ;
endfor
;
save,filename='reglists.idlsave',ntree,treelist,nreg,regname
;
end
