function latlon,vals,dirs
;
; vals contains a list of latitudes or longitudes, as strings, in degree*100
; plus minutes, plus NSEW in dirs.  The values are converted to decimal,
; with S or W given a minus sign.
;
degval=fix(vals)/100
minval=vals mod 100
decval=float(degval)+float(minval)/60.
neglist=where((dirs eq 'S') or (dirs eq 'W'),nneg)
if nneg gt 0 then decval(neglist)=-decval(neglist)
;
return,decval
end
