;
restore,filename='reglists.idlsave'
;
; Ignore 1991 and 1992 (last two values) from all timeseries
;
for i = 0 , nreg-1 do begin
  openw,1,'ext_rwid_'+regname(i)+'.out'
  restore,filename='rwidadj_'+regname(i)+'.idlsave'
  restore,filename='densadj_'+regname(i)+'.idlsave'
  keeplist=where(finite(rwidadj) and (x lt 1993),nkeep)
  y=rwidadj(keeplist)
  x=x(keeplist)
  z=densadj(keeplist)
  slist=sort(y)
  zlist=sort(z)    ; ranked other variable
  printf,1,'Extremes of normalised ringwidth anomalies for region: '+$
      regname(i)
  printf,1,' Low extremes                     | High extremes'
  printf,1,' Rank Year     Width  DensRank    | Rank Year     Width  DensRank'
  for j = 0 , 59 do begin
    k=nkeep-j-1
    orank1=where(zlist eq slist(j))
    orank2=where(zlist eq slist(k))
    printf,1,j+1,x(slist(j)),y(slist(j)),orank1+1,$
          k+1,x(slist(k)),y(slist(k)),orank2+1,$
          format='(2I5,F10.4,I10,6X,2I5,F10.4,I10)'
  endfor
  close,1
endfor
;
end
