;
; Computes correlations on full, high and low pass timeseries of density
; anomalies against full NH temperatures.
;
restore,filename='reglists.idlsave'
;
; Read in timeseries and compute correlations
;
perst=1881.
peren=1960.
;
openw,1,'corr_nhemi.out'
thalf=10.
printf,1,'Correlations between timeseries'
printf,1,'               NH temp. vs. MXD    NH temp. vs. TRW'+$
  ' NH temp. vs. instr.'
printf,1,'     Region    Full  High   Low    Full  High   Low'+$
  '    Full  High   Low'
;
restore,'instrts_nh.idlsave'
totval=total(nhts(*,3:8),2,/nan)
totn=total(finite(nhts(*,3:8)),2)
keeplist=where(totn gt 0,nkeep)
lvx=x
lvy=totval*!values.f_nan
lvy(keeplist)=totval(keeplist)/float(totn(keeplist)) 
filter_cru,thalf,tsin=lvy,tslow=lvylow,tshigh=lvyhi,/nan
;
for i = 0 , nreg-1 do begin
  print,i
  ;
  restore,filename='densadj_'+regname(i)+'.idlsave'
  y1=densadj
  filter_cru,thalf,tsin=y1,tslow=ylow1,tshigh=yhi1,/nan
  ;
  restore,filename='rwidadj_'+regname(i)+'.idlsave'
  y2=rwidadj
  filter_cru,thalf,tsin=y2,tslow=ylow2,tshigh=yhi2,/nan
  ;
  restore,filename='instradj_'+regname(i)+'.idlsave'
  y3=instradj
  filter_cru,thalf,tsin=y3,tslow=ylow3,tshigh=yhi3,/nan
  ;
  if total(abs(lvx-x)) ne 0 then message,'Incompatible years'
  keeplist=where(finite(y1+lvy) and (x ge perst) and (x le peren),nkeep)
  ts1=y1(keeplist)
  ts2=lvy(keeplist)
  r1=correlate(ts1,ts2)
  ;
  ts1=yhi1(keeplist)
  ts2=lvyhi(keeplist)
  r2=correlate(ts1,ts2)
  ;
  ts1=ylow1(keeplist)
  ts2=lvylow(keeplist)
  r3=correlate(ts1,ts2)
  ;
  keeplist=where(finite(y2+lvy) and (x ge perst) and (x le peren),nkeep)
  ts1=y2(keeplist)
  ts2=lvy(keeplist)
  r4=correlate(ts1,ts2)
  ;
  ts1=yhi2(keeplist)
  ts2=lvyhi(keeplist)
  r5=correlate(ts1,ts2)
  ;
  ts1=ylow2(keeplist)
  ts2=lvylow(keeplist)
  r6=correlate(ts1,ts2)
  ;
  keeplist=where(finite(lvy+y3) and (x ge perst) and (x le peren),nkeep)
  ts1=lvy(keeplist)
  ts2=y3(keeplist)
  r7=correlate(ts1,ts2)
  ;
  ts1=lvyhi(keeplist)
  ts2=yhi3(keeplist)
  r8=correlate(ts1,ts2)
  ;
  ts1=lvylow(keeplist)
  ts2=ylow3(keeplist)
  r9=correlate(ts1,ts2)
  ;
  printf,1,regname(i),r1,r2,r3,r4,r5,r6,r7,r8,r9,$
      format='(A11,3(2X,3F6.2))'
  ;
endfor
;
printf,1,' '
printf,1,'Correlations carried out over the period ',perst,peren
printf,1,' '
printf,1,'To separate low and high frequency components, a gaussian weighted'
printf,1,'filter was used with a half-width (years) of ',thalf
;
close,1
;
end
