;
; Outputs regional timeseries
;
; Get region info
;
restore,filename='reglists.idlsave'
regfn=regname
missval=-99.99
;
; For each region
;
for ireg = 0 , nreg-1 do begin
 if (regname(ireg) eq 'NEUR') or (regname(ireg) eq 'SEUR') then begin
  ;
  ; Get adjusted density timeseries, adjusted width and actual temperatures
  ;
  print,'densadj_'+regname(ireg)+'.idlsave'
  restore,filename='densadj_'+regname(ireg)+'.idlsave'
  nt=n_elements(x)
  ;
  misslist=where(finite(densadj) eq 0,nmiss)
  if nmiss gt 0 then densadj(misslist)=missval
  ;
  openw,1,regfn(ireg)+'_mxd.dat'
  printf,1,regname(ireg),format='(A15,5X,"Region name")'
  printf,1,nt,format='(I5,15X,"Number of years")'
  printf,1,missval,format='(F9.4,11X,"Missing value")'
  printf,1,' Year  MXD value'
  for iyr = 0 , nt-1 do begin
    printf,1,x(iyr),densadj(iyr),format='(I5,F9.4)'
  endfor
  close,1
  ;
 endif
endfor
;
end
