;
; Computes lists of tree numbers in each region
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_varget,ncid,'longitude',xlon
ncdf_varget,ncid,'latitude',ylat
ncdf_close,ncid
;
; Define arrays
;
maxtrees=n_elements(xlon)
regname=['ESU','CSU','WSU','NEUR','SEUR','ENA','NWNA','SWNA','ALL',$
  'NORTH','SOUTH']
nreg=n_elements(regname)
ntree=intarr(nreg)
nall=0
iall=8   ; region 8 is everything combined
nnorth=0
inorth=9   ; region 9 is north
nsouth=0
isouth=10   ; region 10 is south
treelist=fltarr(maxtrees,nreg)  &  treelist(*,*)=!values.f_nan
;
; 1) Eastern Soviet Union
;
i=0
keeplist=where( (ylat ge 30.) $
            and (xlon ge 131.) ,nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
treelist(nall:nall+nkeep-1,iall)=keeplist(*)
nall=nall+nkeep
treelist(nnorth:nnorth+nkeep-1,inorth)=keeplist(*)
nnorth=nnorth+nkeep
;
; 2) Central Soviet Union
;
i=1
keeplist=where( (ylat ge 60.) $
            and (xlon lt 131.) and (xlon ge 75.) ,nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
treelist(nall:nall+nkeep-1,iall)=keeplist(*)
nall=nall+nkeep
treelist(nnorth:nnorth+nkeep-1,inorth)=keeplist(*)
nnorth=nnorth+nkeep
;
; 3) Western Soviet Union
;
i=2
keeplist=where( (ylat ge 60.) $
            and (xlon lt 75.) and (xlon ge 38.) ,nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
treelist(nall:nall+nkeep-1,iall)=keeplist(*)
nall=nall+nkeep
treelist(nnorth:nnorth+nkeep-1,inorth)=keeplist(*)
nnorth=nnorth+nkeep
;
; 4) Northern Europe
;
i=3
keeplist=where( (ylat ge 50.) $
            and (xlon lt 38.) and (xlon ge -20.) ,nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
treelist(nall:nall+nkeep-1,iall)=keeplist(*)
nall=nall+nkeep
treelist(nnorth:nnorth+nkeep-1,inorth)=keeplist(*)
nnorth=nnorth+nkeep
;
; 5) Southern Europe
;
i=4
keeplist=where( ( (xlon lt 75.) and (xlon ge -20.) and (ylat lt 50.) ) $
            and ( (xlon ge -3.) or (ylat ge 38.) ) $
            and ( (xlon le 10.) or (ylat ge 41.) ) $
            and ( (xlon le 17.) or (ylat ge 42.) ) $
            and ( (xlon le 22.) or (ylat ge 44.) ) $
             , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
treelist(nall:nall+nkeep-1,iall)=keeplist(*)
nall=nall+nkeep
treelist(nsouth:nsouth+nkeep-1,isouth)=keeplist(*)
nsouth=nsouth+nkeep
;
; 6) Eastern North America
;
i=5
keeplist=where( (xlon gt -99.) and (xlon lt -30.),nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
treelist(nall:nall+nkeep-1,iall)=keeplist(*)
nall=nall+nkeep
treelist(nnorth:nnorth+nkeep-1,inorth)=keeplist(*)
nnorth=nnorth+nkeep
;
; 7) North-western North America
;
i=6
keeplist=where( (xlon le -99.) and (ylat ge 56.) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
treelist(nall:nall+nkeep-1,iall)=keeplist(*)
nall=nall+nkeep
treelist(nnorth:nnorth+nkeep-1,inorth)=keeplist(*)
nnorth=nnorth+nkeep
;
; 8) South-western North America
;
i=7
keeplist=where( (xlon le -99.) and (ylat lt 56.) , nkeep)
ntree(i)=nkeep
treelist(0:nkeep-1,i)=keeplist(*)
treelist(nall:nall+nkeep-1,iall)=keeplist(*)
nall=nall+nkeep
treelist(nsouth:nsouth+nkeep-1,isouth)=keeplist(*)
nsouth=nsouth+nkeep
;
ntree(iall)=nall
ntree(inorth)=nnorth
ntree(isouth)=nsouth
;
save,filename='reglists.idlsave',ntree,treelist,nreg,regname
;
end
