;
; Plots mean timeseries of density anomaly, no. of contributing chronologies
; and fraction of cores available
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_diminq,ncid,'time',dummy,ntime
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'year',x
ncdf_varget,ncid,'density',density
ncdf_attget,ncid,'density','missing_value',valmiss
ncdf_varget,ncid,'fraction',weight
ncdf_close,ncid
;
misslist=where(density eq valmiss,nmiss)
density(misslist)=!values.f_nan
;
totdens=total(density,2,/nan)
totvals=total(finite(density),2)
mdens=totdens/float(totvals)               ; this is the unweighted anomaly
;
mchron=totvals                             ; this is the no. of chronologies
;
totcors=total(weight,2)/float(nstat)       ; this is the fraction of cores
;
totwdens=total(density*weight,2,/nan)
totwvals=total(float(finite(density))*weight,2)
wdens=totwdens/float(totwvals)               ; this is the weighted anomaly
;
; Now plot them
;
multiplot,4
if !d.name eq 'X' then begin
  window,ysize=900
endif else begin
  device,xoffset=2,xsize=17
endelse
;
!x.title='Year'
plot,x,mchron,psym=10,title='Number of contributing chronologies'
plot,x,totcors,psym=10,title='Fraction of cores available'
plot,x,mdens,psym=10,title='Mean normalised density anomaly, unweighted'
plot,x,wdens,psym=10,title='Mean normalised density anomaly, each'+$
  ' chronology weighted by fraction of cores available'
!x.title=''
;
end
