;
; Plots maps of chronology location, tree type, country
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'country',country
ncdf_varget,ncid,'tree',tree
ncdf_varget,ncid,'latitude',ylat
ncdf_varget,ncid,'longitude',xlon
ncdf_close,ncid
;
multiplot,4
!p.multi(1)=2
if !d.name eq 'X' then begin
  window,xsize=650,ysize=950
endif else begin
  device,xsize=15,xoffset=3
  device,ysize=24,yoffset=2
endelse
;
map=def_map(/npolar)  &  map.limit(0)=30.
coast=def_coast(/off)
labels=def_labels(/off)  &  labels.gridon=1  &  labels.dlon=90.
;
restore,filename='reglists.idlsave'
for i = 0 , nreg-1 do begin
;
pause
inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
  title=regname(i)
map_continents,/coasts,color=!p.color,mlinethick=0.5
map_continents,/countries,color=!p.color,mlinestyle=1,mlinethick=0.5
;
x=xlon(treelist(0:ntree(i)-1,i))
y=ylat(treelist(0:ntree(i)-1,i))
cpl_usersym,/circle,/fill
plots,x,y,psym=8,color=!p.background,symsize=0.5
cpl_usersym,/circle
plots,x,y,psym=8,thick=2,symsize=0.5
;
endfor
;
end
