;
restore,filename='reglists.idlsave'
;
for i = 0 , nreg-1 do begin
  openw,1,'ts_'+regname(i)+'.out'
  ;
  ; Get data in
  ;
  restore,filename='instradj_'+regname(i)+'.idlsave'
  restore,filename='rwidadj_'+regname(i)+'.idlsave'
  restore,filename='densadj_'+regname(i)+'.idlsave'
  nyr=n_elements(densadj)
  ;
  ; Do ranking over available data
  ;
  keeplist=where(finite(densadj),nkeep)
  v1=densadj(keeplist)
  s1=sort(v1)
  rank1=intarr(nyr)-999
  k=0
  for j = 0 , nyr-1 do begin
    if finite(densadj(j)) then begin
      rank1(j)=where(s1 eq k)+1
      k=k+1
    endif
  endfor
  keeplist=where(finite(rwidadj),nkeep)
  v1=rwidadj(keeplist)
  s1=sort(v1)
  rank2=intarr(nyr)-999
  k=0
  for j = 0 , nyr-1 do begin
    if finite(rwidadj(j)) then begin
      rank2(j)=where(s1 eq k)+1
      k=k+1
    endif
  endfor
  keeplist=where(finite(instradj),nkeep)
  v1=instradj(keeplist)
  s1=sort(v1)
  rank3=intarr(nyr)-999
  k=0
  for j = 0 , nyr-1 do begin
    if finite(instradj(j)) then begin
      rank3(j)=where(s1 eq k)+1
      k=k+1
    endif
  endfor
  ;
  ; Set to missing flag
  ;
  missval=-9.999
  misslist=where(finite(densadj) eq 0,nmiss)
  if nmiss gt 0 then densadj(misslist)=missval
  misslist=where(finite(rwidadj) eq 0,nmiss)
  if nmiss gt 0 then rwidadj(misslist)=missval
  misslist=where(finite(instradj) eq 0,nmiss)
  if nmiss gt 0 then instradj(misslist)=missval
  ;
  ; Output it
  ;
  printf,1,'Timeseries (variance-adjusted & normalised over 1901-70) for region '+regname(i)
  printf,1,'      | Densities     | Widths        |        | Temperatures'
  printf,1,' Year | Rank  Anomaly | Rank  Anomaly | Nchron | Rank  Anomaly'
  for j = 0 , nyr-1 do begin
    printf,1,x(j),rank1(j),densadj(j),rank2(j),rwidadj(j),n(j),rank3(j),instradj(j), $
          format='(I5," |",I5,F9.3," |",I5,F9.3," |",I7," |",I5,F9.3)'
  endfor
  close,1
endfor
;
end
