function findbest,x,y,break=break
;
; returns the rms error of the best fit of a bent line to data x,y, with the
; bend ocurring at the given break point (break is an element number!).
; x must be monotonically increasing but can contain missing data.
;
; 1) shift the x coordinates so that the break occurs at x=0
;
xzero=x(break)
xin=x-xzero
yzero=y(break)
if finite(yzero) eq 0 then yzero=0.
;
; 1a) remove missing data
;
misslist=where(finite(y) eq 0,nmiss)
if nmiss gt 0 then begin
  return,!values.f_nan
endif
yin=y
;
; 2) use uniform weighting
;
w=xin*0.+1.
;
; 3) specify initial guess
;
a=[yzero,0.,0.]
;
; 4) find best fit
;
yfit=curvefit(xin,yin,w,a,function_name='bentline',iter=iter)
print,'break=',break
print,'iter=',iter
print,'a=',a
;
; 5) compute rms error
;
rmserrs=(yfit-yin)^2
return,sqrt( total(rmserrs) / float(n_elements(yin)) )
;
end
