;
; Plots regional correlations of high frequency timeseries from sliding 15-yr
; windows
;
loadct,39
multi_plot,nrow=5,ncol=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=900
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
;
thalf=40.
refperiod=[1881,1940]
ireg=8
restore,filename='regboxes.idlsave'
restore,filename='instradj_'+regname(ireg)+'.idlsave'
wdens=instradj
mknormal,wdens,x,refperiod=refperiod
filter_cru,thalf,tsin=wdens,tslow=instrlow,tshigh=instrhi,/nan
restore,filename='densadj_'+regname(ireg)+'.idlsave'
mknormal,densadj,x,refperiod=refperiod
filter_cru,thalf,tsin=densadj,tslow=denslow,tshigh=denshi,/nan
plot,x,/nodata,$
  xrange=[1881,1992],xstyle=1,xtitle='Year',$
  yrange=[-2.5,2.5],ystyle=1,ytitle='Low-frequency normalised anomaly'
oplot,x,instrlow
oplot,x,denslow,thick=4
oplot,!x.crange,[0.,0.],linestyle=1
xyouts,1885,1.5,'(c)'
save,filename='briffa_fellow.idlsave',x,instrlow
;
thalf=10.
pp=[1881,1940]
refp=[ [1881,1975] , [pp] , [pp] , [pp] , [pp] , [pp] , [pp] , [pp] , [pp] , $
  [pp] , [pp] ]
;
; Get region info
;
restore,filename='regboxes.idlsave'
regtit=regname
regtit(0:2)=['ESIB','CSIB','WSIB']
for ireg = 8 , 8 do begin
  refperiod=reform(refp(*,ireg))
  restore,filename='instradj_'+regname(ireg)+'.idlsave'
  wdens=instradj
  mknormal,wdens,x,refperiod=refperiod,refmean=refmean,refsd=refsd
  filter_cru,thalf,tsin=wdens,tslow=instrlow,tshigh=instrhi,/nan
  ;
  restore,filename='densadj_'+regname(ireg)+'.idlsave'
  mknormal,densadj,x,refperiod=refperiod,refmean=refmean,refsd=refsd
  filter_cru,thalf,tsin=densadj,tslow=denslow,tshigh=denshi,/nan
  ;
  restore,filename='rwidadj_'+regname(ireg)+'.idlsave'
  mknormal,rwidadj,x,refperiod=refperiod,refmean=refmean,refsd=refsd
  filter_cru,thalf,tsin=rwidadj,tslow=rwidlow,tshigh=rwidhi,/nan
  ;
  ; and overplot correlation of 15-yr segments (implicitly high freq.)
  ;
  seglen=15
  nlin=1992-1881+1-seglen
  a15h=fltarr(nlin)
  a15hr=fltarr(nlin)
  for ii = 0 , nlin-1 do begin
    xx=indgen(seglen)+1881-1600+ii
    a15h(ii)=correlate(denshi(xx),instrhi(xx))
    a15hr(ii)=correlate(rwidhi(xx),instrhi(xx))
  endfor
  plot,findgen(nlin)+1881+seglen/2.,a15h,thick=4,$
    /ystyle,yrange=[-1.,1.],ytitle='High-frequency correlation',$
    /xstyle,xrange=[1881,1992],xtitle='Central year of sliding 15-yr window'
  oplot,findgen(nlin)+1881+seglen/2.,a15hr
  oplot,!x.crange,[0.,0.],linestyle=1
  xyouts,1885,-0.8,'(d)'
  ;
endfor
;
end
