;
loadct,39
multi_plot,nrow=2,ncol=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  fac=1.
endif else begin
  fac=2.
endelse
def_1color,10,color='vvlgreen'
;
map=def_map(/npolar)  &  map.limit(0)=30.
labels=def_labels(/off)  &  labels.gridon=0  &  labels.dlon=30.
labels.dlat=10.
coast=def_coast(/get_device)
coast.double=0
coast.fill=1
coast.fillcolor=10
coast.thick=[0.5,0.5]
;
inter_boxfd,/nodata,map=map,$
  labels=labels,coast=coast
;
xcir=findgen(361)-180.
ycir=replicate(30.,361)
map_plots,xcir,ycir
;
x1=[180.,131.,75.,38.,-40.,-99.]
y1=[30.,30.,30.,30.,30.,30.]
x2=[180.,131.,75.,38.,-40.,-99.]
y2=[90.,90.,90.,90.,90.,90.]
n=n_elements(x1)
for i = 0 , n-1 do begin
  map_plots,[x1(i),x2(i)],[y1(i),y2(i)],thick=5
endfor
;
xs=findgen(79)-40.
ys=replicate(50.,79)
map_plots,xs,ys,thick=5
;
xs=findgen(82)-180.
ys=replicate(56.,82)
map_plots,xs,ys,thick=5
;
; Plots maps of chronology location
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'country',country
ncdf_varget,ncid,'tree',tree & tree=string(tree)
ncdf_varget,ncid,'statid',statid & statid=string(statid)
ncdf_varget,ncid,'statabbr',statabbr & statabbr=string(statabbr)
ncdf_varget,ncid,'statloc',statloc & statloc=string((statloc <126B) >32B)  ; get rid of control codes
ncdf_varget,ncid,'yrstart',yrst
ncdf_varget,ncid,'yrend',yren
ncdf_varget,ncid,'tree',tree & tree=string(tree)
ncdf_varget,ncid,'latitude',ylat
ncdf_varget,ncid,'longitude',xlon
ncdf_close,ncid
;
restore,filename='reglists.idlsave'
iall=where(regname eq 'ALL')
i=iall(0)
;
; Output table of sites used
;
ns=ntree[i]
sl=treelist[0:ns-1,i]
openw,1,'b98sens_site.txt'
printf,1,'Table of tree-ring sites used in'
printf,1
printf,1,'Briffa KR et al. (1998) Reduced sensitivity of recent tree growth to temperature at high northern latitudes. Nature 391, 678-682.'
printf,1
printf,1,'Number of sites: '+txt(ns)
printf,1
printf,1,'    ID                      Name     Abbr Genus Longitude  Latitude Start   End'
for is = 0 , ns-1 do printf,1,strtrim(statid[sl[is]],2),strtrim(statloc[sl[is]],2),$
 strtrim(statabbr[sl[is]],2),strtrim(tree[sl[is]],2),xlon[sl[is]],ylat[sl[is]],$
 yrst[sl[is]],yren[sl[is]],$
 format='(A6,A26,A9,A6,2F10.2,2I6)'
close,1
;
x=xlon(treelist(0:ntree(i)-1,i))
y=ylat(treelist(0:ntree(i)-1,i))
cpl_usersym,/circle,/fill
plots,x,y,psym=8,color=!p.background,symsize=1.05,noclip=0
cpl_usersym,/circle
plots,x,y,psym=8,thick=1,symsize=1.05,noclip=0
print,'Number of sites:',n_elements(x)
;
regname(0:2)=['ESIB','CSIB','WSIB']
rnx=[170,95,50,-35,-33,-48,-128,-160]
rny=[40,45,42,53,33,33,75,36]
for ir = 0 , 7 do $
  xyouts,rnx(ir),rny(ir),regname(ir)
;
end
